/*
 * Decompiled with CFR 0.152.
 */
package ksg;

public class Vector3 {
    public float x;
    public float y;
    public float z;
    private static final int WORK_NUM = 16;
    private static int m_nUsedWorkNum;
    private static Vector3[] WORKS;

    public Vector3() {
        this.Zero();
    }

    public Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void Set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public void Set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public boolean equals(Vector3 vector3) {
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void Zero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public void Add(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
    }

    public void Add(Vector3 vector3, Vector3 vector32) {
        this.x = vector3.x + vector32.x;
        this.y = vector3.y + vector32.y;
        this.z = vector3.z + vector32.z;
    }

    public void Sub(Vector3 vector3) {
        this.x -= vector3.x;
        this.y -= vector3.y;
        this.z -= vector3.z;
    }

    public void Sub(Vector3 vector3, Vector3 vector32) {
        this.x = vector3.x - vector32.x;
        this.y = vector3.y - vector32.y;
        this.z = vector3.z - vector32.z;
    }

    public void Scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public void Scale(Vector3 vector3, float f) {
        this.x = vector3.x * f;
        this.y = vector3.y * f;
        this.z = vector3.z * f;
    }

    public float Length() {
        return (float)Math.sqrt(this.Dot(this));
    }

    public float Length(Vector3 vector3) {
        float f = vector3.x - this.x;
        float f2 = vector3.y - this.y;
        float f3 = vector3.z - this.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public float Dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public void Cross(Vector3 vector3, Vector3 vector32) {
        this.x = vector3.y * vector32.z - vector3.z * vector32.y;
        this.y = vector3.z * vector32.x - vector3.x * vector32.z;
        this.z = vector3.x * vector32.y - vector3.y * vector32.x;
    }

    public void Normalize() {
        this.Normalize(this);
    }

    public void Normalize(Vector3 vector3) {
        float f = 1.0f / vector3.Length();
        this.x = vector3.x * f;
        this.y = vector3.y * f;
        this.z = vector3.z * f;
    }

    public void Interpolate(Vector3 vector3, Vector3 vector32, float f) {
        float f2 = 1.0f - f;
        this.x = f2 * vector3.x + f * vector32.x;
        this.y = f2 * vector3.y + f * vector32.y;
        this.z = f2 * vector3.z + f * vector32.z;
    }

    protected static void SystemInit() {
        for (int i = 0; i < WORKS.length; ++i) {
            Vector3.WORKS[i] = new Vector3();
        }
        m_nUsedWorkNum = 0;
    }

    public static Vector3 Push() {
        return WORKS[m_nUsedWorkNum++];
    }

    public static void Pop(int n) {
        m_nUsedWorkNum -= n;
    }

    static {
        WORKS = new Vector3[16];
    }
}

