/*
 * Decompiled with CFR 0.152.
 */
package ksg;

public class TriFunc {
    private static float PI_2 = (float)Math.PI * 2;
    private static float NUM_DIV_ANG;
    private static float NUM_DIV_ANG_360;
    private static float NUM_DIV_ANG_4096;
    private static float[] SIN_TABLE;
    private static float[] COS_TABLE;
    private static float[] TAN_TABLE;

    public static void Init(int n) {
        NUM_DIV_ANG = (float)n / PI_2;
        NUM_DIV_ANG_360 = (float)n / 360.0f;
        NUM_DIV_ANG_4096 = (float)n / 4096.0f;
        SIN_TABLE = new float[n];
        COS_TABLE = new float[n];
        TAN_TABLE = new float[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)PI_2 * (double)i / (double)n;
            TriFunc.COS_TABLE[i] = (float)Math.cos(d);
            TriFunc.SIN_TABLE[i] = (float)Math.sin(d);
            TriFunc.TAN_TABLE[i] = (float)Math.tan(d);
        }
    }

    public static float GetAdjustAng(float f, float f2) {
        if (f >= f2) {
            f %= f2;
        } else if (f < 0.0f) {
            f = f2 + f % f2;
        }
        return f % f2;
    }

    public static int GetTableIndex(float f) {
        f = TriFunc.GetAdjustAng(f, PI_2);
        return (int)(NUM_DIV_ANG * f);
    }

    public static int GetTableIndex360(float f) {
        f = TriFunc.GetAdjustAng(f, 360.0f);
        return (int)(NUM_DIV_ANG_360 * f);
    }

    public static int GetTableIndex4096(float f) {
        f = TriFunc.GetAdjustAng(f, 4096.0f);
        return (int)(NUM_DIV_ANG_4096 * f);
    }

    public static float Sin(float f) {
        int n = TriFunc.GetTableIndex(f);
        return SIN_TABLE[n];
    }

    public static float Cos(float f) {
        int n = TriFunc.GetTableIndex(f);
        return COS_TABLE[n];
    }

    public static float Tan(float f) {
        int n = TriFunc.GetTableIndex(f);
        return TAN_TABLE[n];
    }

    public static float Sin360(float f) {
        int n = TriFunc.GetTableIndex360(f);
        return SIN_TABLE[n];
    }

    public static float Cos360(float f) {
        int n = TriFunc.GetTableIndex360(f);
        return COS_TABLE[n];
    }

    public static float Tan360(float f) {
        int n = TriFunc.GetTableIndex360(f);
        return TAN_TABLE[n];
    }

    public static float Cos4096(float f) {
        int n = TriFunc.GetTableIndex4096(f);
        return COS_TABLE[n];
    }

    public static float Sin4096(float f) {
        int n = TriFunc.GetTableIndex4096(f);
        return SIN_TABLE[n];
    }
}

