/*
 * Decompiled with CFR 0.152.
 */
package ksg;

import com.mexa.opgl.Buffer;
import com.mexa.opgl.ByteBuffer;
import com.mexa.opgl.OpglGraphics;
import com.mexa.opgl.ShortBuffer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import ksg.KSGBase;

public class Texture {
    private short m_nWidth;
    private short m_nHeight;
    private byte m_nFormat;
    private byte m_nType;
    private int m_nTexID;
    public static final byte FORMAT_ALPHA = 0;
    public static final byte FORMAT_LUMINANCE = 1;
    public static final byte FORMAT_LUMINANCE_ALPHA = 2;
    public static final byte FORMAT_RGB = 3;
    public static final byte FORMAT_RGBA = 4;
    public static final byte TYPE_BYTE = 0;
    public static final byte TYPE_SHORT565 = 1;
    public static final byte TYPE_SHORT4444 = 2;
    public static final byte TYPE_SHORT5551 = 3;

    private Texture() {
    }

    private Texture(DataInputStream dataInputStream, boolean bl) throws IOException {
        this.Create(dataInputStream, bl);
    }

    private Texture(byte[] byArray, short s, short s2, byte by, byte by2) throws IOException {
        this.Create(byArray, s, s2, by, by2, false);
    }

    public void Bind() {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glBindTexture(3553, this.GetTexID());
    }

    public short GetWidth() {
        return this.m_nWidth;
    }

    public short GetHeight() {
        return this.m_nHeight;
    }

    public byte GetFormat() {
        return this.m_nFormat;
    }

    public byte GetType() {
        return this.m_nType;
    }

    public int GetTexID() {
        return this.m_nTexID;
    }

    public static Texture[] CreateFromJFTX(String string) throws IOException {
        return Texture.CreateFromJFTX(Connector.openInputStream((String)string));
    }

    public static Texture[] CreateFromJFTX2(String string) throws IOException {
        return Texture.CreateFromJFTX2(Connector.openInputStream((String)string));
    }

    public static Texture[] CreateFromJFTX(byte[] byArray, short s, short s2, byte by, byte by2) throws IOException {
        Texture[] textureArray = new Texture[]{new Texture(byArray, s, s2, by, by2)};
        return textureArray;
    }

    public static Texture[] CreateFromJFTX(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        byte by4 = dataInputStream.readByte();
        byte by5 = dataInputStream.readByte();
        byte by6 = dataInputStream.readByte();
        byte by7 = dataInputStream.readByte();
        byte by8 = dataInputStream.readByte();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        Texture[] textureArray = new Texture[n2];
        for (int i = 0; i < n2; ++i) {
            textureArray[i] = new Texture(dataInputStream, false);
        }
        return textureArray;
    }

    public static Texture[] CreateFromJFTX2(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        byte by4 = dataInputStream.readByte();
        byte by5 = dataInputStream.readByte();
        byte by6 = dataInputStream.readByte();
        byte by7 = dataInputStream.readByte();
        byte by8 = dataInputStream.readByte();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            return null;
        }
        Texture[] textureArray = new Texture[n2];
        for (int i = 0; i < n2; ++i) {
            textureArray[i] = new Texture(dataInputStream, true);
        }
        return textureArray;
    }

    public static int GetDepthBit(byte by, byte by2) {
        switch (by) {
            case 0: 
            case 1: {
                return 8;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return by2 == 0 ? 24 : 16;
            }
            case 4: {
                return by2 == 0 ? 32 : 16;
            }
        }
        return 0;
    }

    private void Create(DataInputStream dataInputStream, boolean bl) throws IOException {
        this.m_nWidth = dataInputStream.readShort();
        this.m_nHeight = dataInputStream.readShort();
        this.m_nFormat = dataInputStream.readByte();
        this.m_nType = dataInputStream.readByte();
        int n = this.m_nWidth * this.m_nHeight * Texture.GetDepthBit(this.m_nFormat, this.m_nType) / 8;
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        this.Create(byArray, this.m_nWidth, this.m_nHeight, this.m_nFormat, this.m_nType, bl);
    }

    private void Create(byte[] byArray, short s, short s2, byte by, byte by2, boolean bl) throws IOException {
        ShortBuffer shortBuffer;
        Object object;
        this.m_nWidth = s;
        this.m_nHeight = s2;
        this.m_nFormat = by;
        this.m_nType = by2;
        int n = this.m_nWidth * this.m_nHeight * Texture.GetDepthBit(this.m_nFormat, this.m_nType) / 8;
        if (this.m_nType == 0) {
            object = ByteBuffer.allocateDirect((int)n);
            object.put(0, byArray, 0, byArray.length);
            shortBuffer = object;
        } else {
            shortBuffer = KSGBase.CreateShortBuffer(byArray);
        }
        object = new int[1];
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glGenTextures((int[])object);
        this.m_nTexID = (int)object[0];
        int[] nArray = new int[]{6406, 6409, 6410, 6407, 6408};
        int[] nArray2 = new int[]{5121, 33635, 32819, 32820};
        opglGraphics.glBindTexture(3553, this.GetTexID());
        opglGraphics.glTexImage2D(3553, 0, nArray[this.m_nFormat], (int)this.m_nWidth, (int)this.m_nHeight, 0, nArray[this.m_nFormat], nArray2[this.m_nType], (Buffer)shortBuffer);
        if (bl) {
            opglGraphics.glTexParameterf(3553, 10241, 9728.0f);
            opglGraphics.glTexParameterf(3553, 10240, 9728.0f);
        } else {
            opglGraphics.glTexParameterf(3553, 10241, 9729.0f);
            opglGraphics.glTexParameterf(3553, 10240, 9729.0f);
        }
        opglGraphics.glTexParameterf(3553, 10242, 10497.0f);
        opglGraphics.glTexParameterf(3553, 10243, 10497.0f);
        opglGraphics.glTexEnvf(8960, 8704, 8448.0f);
    }

    public void Destroy() {
        if (this.m_nTexID > 0) {
            int[] nArray = new int[]{this.m_nTexID};
            OpglGraphics opglGraphics = KSGBase.GetGL();
            opglGraphics.glDeleteTextures(nArray);
            this.m_nTexID = 0;
        }
    }
}

