/*
 * Decompiled with CFR 0.152.
 */
package ksg;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;

public class Motion {
    private int m_nFrameNum;
    private INode[] m_Nodes;

    private static float CalcValue(SKeyFrame[] sKeyFrameArray, int n) {
        SKeyFrame sKeyFrame;
        int n2;
        int n3 = n2 = sKeyFrameArray.length >> 1;
        int n4 = sKeyFrameArray.length - n2 - 1;
        while (true) {
            int n5;
            sKeyFrame = sKeyFrameArray[n2];
            if (n <= sKeyFrame.nFrame) {
                if (n3 == 0) break;
                n5 = (n3 >> 1) + 1;
                n2 -= n5;
                n3 -= n5;
                n4 = n5 - 1;
                continue;
            }
            if (n4 == 0) {
                sKeyFrame = sKeyFrameArray[n2 + 1];
                break;
            }
            n5 = (n4 >> 1) + 1;
            n2 += n5;
            n3 = n5 - 1;
            n4 -= n5;
        }
        return sKeyFrame.fC * (float)n * (float)n + sKeyFrame.fB * (float)n + sKeyFrame.fA;
    }

    public Motion() {
    }

    public Motion(String string) throws IOException {
        this.Create(Connector.openInputStream((String)string));
    }

    public Motion(InputStream inputStream) throws IOException {
        this.Create(inputStream);
    }

    public void Create(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        if (by != 74 || by2 != 75) {
            byte by3 = by;
            this.m_nFrameNum = by2;
            this.m_Nodes = new SSimpleNode[by3];
            for (byte by4 = 0; by4 < by3; by4 = (byte)(by4 + 1)) {
                this.m_Nodes[by4] = new SSimpleNode();
                this.m_Nodes[by4].Create(dataInputStream);
            }
        } else {
            byte by5 = dataInputStream.readByte();
            byte by6 = dataInputStream.readByte();
            byte by7 = dataInputStream.readByte();
            byte by8 = dataInputStream.readByte();
            byte by9 = dataInputStream.readByte();
            byte by10 = dataInputStream.readByte();
            byte by11 = dataInputStream.readByte();
            dataInputStream.skip(1L);
            this.m_nFrameNum = dataInputStream.readShort() & 0xFFFF;
            this.m_Nodes = new SNode[by11];
            for (byte by12 = 0; by12 < by11; by12 = (byte)(by12 + 1)) {
                this.m_Nodes[by12] = new SNode();
                this.m_Nodes[by12].Create(dataInputStream);
            }
        }
    }

    protected INode GetNode(byte by) {
        return this.m_Nodes[by];
    }

    public int GetNodeNum() {
        return this.m_Nodes.length;
    }

    public int GetFrameNum() {
        return this.m_nFrameNum;
    }

    protected class SSimpleNode
    implements INode {
        public float[] rx;
        public float[] ry;
        public float[] rz;
        public float[] tx;
        public float[] ty;
        public float[] tz;

        protected SSimpleNode() {
        }

        public void Create(DataInputStream dataInputStream) throws IOException {
            byte by = dataInputStream.readByte();
            if ((by >> 5 & 1) != 0) {
                this.rx = this.CreateRotKeys(dataInputStream);
            }
            if ((by >> 4 & 1) != 0) {
                this.ry = this.CreateRotKeys(dataInputStream);
            }
            if ((by >> 3 & 1) != 0) {
                this.rz = this.CreateRotKeys(dataInputStream);
            }
            if ((by >> 2 & 1) != 0) {
                this.tx = this.CreateTransKeys(dataInputStream);
            }
            if ((by >> 1 & 1) != 0) {
                this.ty = this.CreateTransKeys(dataInputStream);
            }
            if ((by >> 0 & 1) != 0) {
                this.tz = this.CreateTransKeys(dataInputStream);
            }
        }

        private float[] CreateRotKeys(DataInputStream dataInputStream) throws IOException {
            float[] fArray = new float[Motion.this.m_nFrameNum];
            for (int n = 0; n < fArray.length; n = (int)((short)(n + 1))) {
                short s = dataInputStream.readShort();
                fArray[n] = (float)(Math.PI * (double)s / 32767.0);
            }
            return fArray;
        }

        private float[] CreateTransKeys(DataInputStream dataInputStream) throws IOException {
            float[] fArray = new float[Motion.this.m_nFrameNum];
            for (int n = 0; n < fArray.length; n = (int)((short)(n + 1))) {
                fArray[n] = dataInputStream.readFloat();
            }
            return fArray;
        }

        public boolean IsValidRX() {
            return this.rx != null;
        }

        public boolean IsValidRY() {
            return this.ry != null;
        }

        public boolean IsValidRZ() {
            return this.rz != null;
        }

        public boolean IsValidTX() {
            return this.tx != null;
        }

        public boolean IsValidTY() {
            return this.ty != null;
        }

        public boolean IsValidTZ() {
            return this.tz != null;
        }

        public float GetRX(int n) {
            return this.rx[n];
        }

        public float GetRY(int n) {
            return this.ry[n];
        }

        public float GetRZ(int n) {
            return this.rz[n];
        }

        public float GetTX(int n) {
            return this.tx[n];
        }

        public float GetTY(int n) {
            return this.ty[n];
        }

        public float GetTZ(int n) {
            return this.tz[n];
        }
    }

    protected class SNode
    implements INode {
        public SKeyFrame[] rx;
        public SKeyFrame[] ry;
        public SKeyFrame[] rz;
        public SKeyFrame[] tx;
        public SKeyFrame[] ty;
        public SKeyFrame[] tz;

        protected SNode() {
        }

        public void Create(DataInputStream dataInputStream) throws IOException {
            this.rx = this.CreateKeys(dataInputStream);
            this.ry = this.CreateKeys(dataInputStream);
            this.rz = this.CreateKeys(dataInputStream);
            this.tx = this.CreateKeys(dataInputStream);
            this.ty = this.CreateKeys(dataInputStream);
            this.tz = this.CreateKeys(dataInputStream);
        }

        private SKeyFrame[] CreateKeys(DataInputStream dataInputStream) throws IOException {
            short s = (short)(dataInputStream.readByte() & 0xFF);
            if (s == 0) {
                return null;
            }
            SKeyFrame[] sKeyFrameArray = new SKeyFrame[s];
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                SKeyFrame sKeyFrame = new SKeyFrame();
                sKeyFrame.fA = dataInputStream.readFloat();
                sKeyFrame.fB = dataInputStream.readFloat();
                sKeyFrame.fC = dataInputStream.readFloat();
                sKeyFrame.nFrame = dataInputStream.readShort() & 0xFFFF;
                sKeyFrameArray[s2] = sKeyFrame;
            }
            return sKeyFrameArray;
        }

        public boolean IsValidRX() {
            return this.rx != null;
        }

        public boolean IsValidRY() {
            return this.ry != null;
        }

        public boolean IsValidRZ() {
            return this.rz != null;
        }

        public boolean IsValidTX() {
            return this.tx != null;
        }

        public boolean IsValidTY() {
            return this.ty != null;
        }

        public boolean IsValidTZ() {
            return this.tz != null;
        }

        public float GetRX(int n) {
            return Motion.CalcValue(this.rx, n);
        }

        public float GetRY(int n) {
            return Motion.CalcValue(this.ry, n);
        }

        public float GetRZ(int n) {
            return Motion.CalcValue(this.rz, n);
        }

        public float GetTX(int n) {
            return Motion.CalcValue(this.tx, n);
        }

        public float GetTY(int n) {
            return Motion.CalcValue(this.ty, n);
        }

        public float GetTZ(int n) {
            return Motion.CalcValue(this.tz, n);
        }
    }

    protected static interface INode {
        public void Create(DataInputStream var1) throws IOException;

        public float GetRX(int var1);

        public float GetRY(int var1);

        public float GetRZ(int var1);

        public float GetTX(int var1);

        public float GetTY(int var1);

        public float GetTZ(int var1);

        public boolean IsValidRX();

        public boolean IsValidRY();

        public boolean IsValidRZ();

        public boolean IsValidTX();

        public boolean IsValidTY();

        public boolean IsValidTZ();
    }

    protected class SKeyFrame {
        public float fA;
        public float fB;
        public float fC;
        public int nFrame;

        protected SKeyFrame() {
        }
    }
}

