/*
 * Decompiled with CFR 0.152.
 */
package ksg;

import com.mexa.opgl.OpglGraphics;
import ksg.KSGBase;
import ksg.Matrix44;
import ksg.Model;
import ksg.Motion;
import ksg.Texture;

public class ModelInst {
    public Matrix44[] m_matNodes;

    public ModelInst() {
    }

    public ModelInst(byte by) {
        this.CreateNode(by);
    }

    public void CreateNode(byte by) {
        this.m_matNodes = new Matrix44[by];
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            this.m_matNodes[by2] = new Matrix44();
        }
    }

    public Matrix44 GetNode(byte by) {
        return this.m_matNodes[by];
    }

    public void Update(Model model) {
        for (byte by = 0; by < model.GetNodeNum(); by = (byte)(by + 1)) {
            Model.SNodeInfo sNodeInfo = model.GetNode(by);
            this.m_matNodes[by].RotXYZ33(sNodeInfo.fRotX, sNodeInfo.fRotY, sNodeInfo.fRotZ);
            this.m_matNodes[by].SetRow(3, sNodeInfo.fTransX, sNodeInfo.fTransY, sNodeInfo.fTransZ);
        }
        this.SolveHierarchy(model);
    }

    public void Update(Model model, Motion motion, int n) {
        this.ApplyMotion(model, motion, n);
        this.SolveHierarchy(model);
    }

    public void ApplyMotion(Model model, Motion motion, int n) {
        for (byte by = 0; by < motion.GetNodeNum(); by = (byte)(by + 1)) {
            Model.SNodeInfo sNodeInfo = model.GetNode(by);
            Motion.INode iNode = motion.GetNode(by);
            float f = iNode.IsValidRX() ? iNode.GetRX(n) : sNodeInfo.fRotX;
            float f2 = iNode.IsValidRY() ? iNode.GetRY(n) : sNodeInfo.fRotY;
            float f3 = iNode.IsValidRZ() ? iNode.GetRZ(n) : sNodeInfo.fRotZ;
            float f4 = iNode.IsValidTX() ? iNode.GetTX(n) : sNodeInfo.fTransX;
            float f5 = iNode.IsValidTY() ? iNode.GetTY(n) : sNodeInfo.fTransY;
            float f6 = iNode.IsValidTZ() ? iNode.GetTZ(n) : sNodeInfo.fTransZ;
            this.m_matNodes[by].RotXYZ33(f, f2, f3);
            this.m_matNodes[by].SetRow(3, f4, f5, f6);
        }
    }

    public void SolveHierarchy(Model model) {
        for (byte by = 1; by < model.GetNodeNum(); by = (byte)(by + 1)) {
            Model.SNodeInfo sNodeInfo = model.GetNode(by);
            if (sNodeInfo.nParentID < 0) continue;
            this.m_matNodes[by].Mul34(this.m_matNodes[sNodeInfo.nParentID]);
        }
    }

    public void Render(Model model, Texture texture, Matrix44 matrix44) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glBindTexture(3553, texture.GetTexID());
        opglGraphics.glMatrixMode(5888);
        opglGraphics.glPushMatrix();
        opglGraphics.glMultMatrixf(matrix44.GetElems());
        opglGraphics.glEnable(34880);
        if (model.GetClusterNum() > 0) {
            this.RenderCluster(model);
        } else {
            byte by = model.GetPrimNum();
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                Model.SPrimData sPrimData = model.GetPrim(by2);
                this.Render(model, sPrimData);
            }
        }
        opglGraphics.glDisable(34880);
        opglGraphics.glDisableClientState(34884);
        opglGraphics.glDisableClientState(34477);
        opglGraphics.glDisableClientState(32885);
        opglGraphics.glDisableClientState(32886);
        opglGraphics.glDisableClientState(32888);
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glPopMatrix();
    }

    public static void RenderDirect(Model model, Texture[] textureArray, Matrix44 matrix44) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        byte by = -1;
        opglGraphics.glMatrixMode(5888);
        opglGraphics.glPushMatrix();
        opglGraphics.glMultMatrixf(matrix44.GetElems());
        byte by2 = model.GetPrimNum();
        for (byte by3 = 0; by3 < by2; by3 = (byte)(by3 + 1)) {
            Model.SPrimData sPrimData = model.GetPrim(by3);
            if (by != sPrimData.nTexID) {
                by = sPrimData.nTexID;
                opglGraphics.glBindTexture(3553, textureArray[by].GetTexID());
            }
            ModelInst.RenderDirect(model, sPrimData);
        }
        opglGraphics.glDisableClientState(32885);
        opglGraphics.glDisableClientState(32886);
        opglGraphics.glDisableClientState(32888);
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glPopMatrix();
    }

    public static void RenderDirect(Model model, Texture texture, Matrix44 matrix44) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glBindTexture(3553, texture.GetTexID());
        opglGraphics.glMatrixMode(5888);
        opglGraphics.glPushMatrix();
        opglGraphics.glMultMatrixf(matrix44.GetElems());
        byte by = model.GetPrimNum();
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            Model.SPrimData sPrimData = model.GetPrim(by2);
            ModelInst.RenderDirect(model, sPrimData);
        }
        opglGraphics.glDisableClientState(32885);
        opglGraphics.glDisableClientState(32886);
        opglGraphics.glDisableClientState(32888);
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glPopMatrix();
    }

    protected void Render(Model model, Model.SPrimData sPrimData) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        Model.SVBInfo sVBInfo = model.GetVBInfo(sPrimData.nVBIndex);
        int n = sVBInfo.GetVertexSize();
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
        opglGraphics.glVertexPointer(3, 5126, n, 0);
        opglGraphics.glEnableClientState(32888);
        opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
        opglGraphics.glTexCoordPointer(2, 5126, n, 12);
        if (sVBInfo.nType == 0) {
            opglGraphics.glEnableClientState(32885);
            opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
            opglGraphics.glNormalPointer(5120, n, 28);
            opglGraphics.glEnableClientState(34477);
            opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
            opglGraphics.glWeightPointerOES(1, 5126, n, 24);
            opglGraphics.glEnableClientState(34884);
            opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
            opglGraphics.glMatrixIndexPointerOES(1, 5121, n, 31);
            for (int i = 0; i < sPrimData.nMatrixNum; ++i) {
                opglGraphics.glPushMatrix();
                opglGraphics.glMultMatrixf(this.m_matNodes[sPrimData.nMatrixIDs[i]].GetElems());
                opglGraphics.glCurrentPaletteMatrixOES(i);
                opglGraphics.glLoadPaletteFromModelViewMatrixOES();
                opglGraphics.glPopMatrix();
            }
        } else {
            int n2 = sVBInfo.nType * 2;
            int n3 = 24 + 4 * n2;
            int n4 = n3 + 4;
            opglGraphics.glEnableClientState(32885);
            opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
            opglGraphics.glNormalPointer(5120, n, n3);
            opglGraphics.glEnableClientState(34477);
            opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
            opglGraphics.glWeightPointerOES(n2, 5126, n, 24);
            opglGraphics.glEnableClientState(34884);
            opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
            opglGraphics.glMatrixIndexPointerOES(n2, 5121, n, n4);
            for (int i = 0; i < sPrimData.nMatrixNum * n2; ++i) {
                if (sPrimData.nMatrixIDs[i] == 0) continue;
                opglGraphics.glPushMatrix();
                Model.SMatrixInfo sMatrixInfo = model.GetMatrixInfo(sPrimData.nMatrixIDs[i]);
                if (sMatrixInfo.nSkeletonID == sMatrixInfo.nNodeID) {
                    opglGraphics.glMultMatrixf(this.m_matNodes[sMatrixInfo.nNodeID].GetElems());
                } else {
                    Matrix44 matrix44 = model.GetMatrix(sPrimData.nMatrixIDs[i]);
                    opglGraphics.glMultMatrixf(this.m_matNodes[sMatrixInfo.nSkeletonID].GetElems());
                    opglGraphics.glMultMatrixf(matrix44.GetElems());
                }
                opglGraphics.glCurrentPaletteMatrixOES(i);
                opglGraphics.glLoadPaletteFromModelViewMatrixOES();
                opglGraphics.glPopMatrix();
            }
        }
        opglGraphics.glBindBuffer(34963, sVBInfo.nIndexVBO);
        opglGraphics.glDrawElements(5, (int)sPrimData.nIndexNum, 5123, sPrimData.nStartIndex * 2);
    }

    protected void RenderCluster(Model model) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        int n = model.GetVBO(0);
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, n);
        opglGraphics.glVertexPointer(3, 5126, 28, 0);
        opglGraphics.glEnableClientState(32888);
        opglGraphics.glBindBuffer(34962, n);
        opglGraphics.glTexCoordPointer(2, 5126, 28, 12);
        opglGraphics.glEnableClientState(32885);
        opglGraphics.glBindBuffer(34962, n);
        opglGraphics.glNormalPointer(5120, 28, 24);
        opglGraphics.glEnableClientState(34477);
        opglGraphics.glBindBuffer(34962, Model.s_nVBOs[0]);
        opglGraphics.glWeightPointerOES(1, 5126, 4, 0);
        opglGraphics.glEnableClientState(34884);
        opglGraphics.glBindBuffer(34962, n);
        opglGraphics.glMatrixIndexPointerOES(1, 5121, 28, 27);
        for (byte by = 0; by < model.GetClusterNum(); by = (byte)(by + 1)) {
            Model.SCluster sCluster = model.GetCluster(by);
            for (int i = 0; i < sCluster.nMatrixIDs.length; ++i) {
                opglGraphics.glPushMatrix();
                opglGraphics.glMultMatrixf(this.m_matNodes[sCluster.nMatrixIDs[i]].GetElems());
                opglGraphics.glCurrentPaletteMatrixOES(i);
                opglGraphics.glLoadPaletteFromModelViewMatrixOES();
                opglGraphics.glPopMatrix();
            }
            opglGraphics.glDrawArrays(4, sCluster.nOffset * 3, sCluster.nPolyNum * 3);
        }
    }

    protected static void RenderDirect(Model model, Model.SPrimData sPrimData) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        Model.SVBInfo sVBInfo = model.GetVBInfo(sPrimData.nVBIndex);
        int n = sVBInfo.GetVertexSize();
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
        opglGraphics.glVertexPointer(3, 5126, n, 0);
        opglGraphics.glEnableClientState(32888);
        opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
        opglGraphics.glTexCoordPointer(2, 5126, n, 12);
        opglGraphics.glEnableClientState(32886);
        opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
        opglGraphics.glColorPointer(4, 5121, n, 20);
        opglGraphics.glEnableClientState(32885);
        opglGraphics.glBindBuffer(34962, sVBInfo.nVertexVBO);
        opglGraphics.glNormalPointer(5120, n, 24);
        opglGraphics.glBindBuffer(34963, sVBInfo.nIndexVBO);
        opglGraphics.glDrawElements(5, (int)sPrimData.nIndexNum, 5123, sPrimData.nStartIndex * 2);
    }
}

