/*
 * Decompiled with CFR 0.152.
 */
package ksg;

import com.mexa.opgl.Buffer;
import com.mexa.opgl.ByteBuffer;
import com.mexa.opgl.FloatBuffer;
import com.mexa.opgl.OpglGraphics;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import ksg.KSGBase;
import ksg.Matrix44;

public class Model {
    public static final int COMMON_VBO_WEIGHT = 0;
    public static final int COMMON_VBO_NUM = 1;
    public static int[] s_nVBOs;
    private static final int[] VERTEX_SIZE;
    public static final int CLUSTER_VERTEX_SIZE = 28;
    private SFileHeader m_Header;
    private SNodeInfo[] m_Nodes;
    private Matrix44[] m_Matrices;
    private SMatrixInfo[] m_MatrixInfos;
    private SVBInfo[] m_VBs;
    private SPrimData[] m_Prims;
    private SCluster[] m_Clusters;
    private int[] m_nVBOs;

    public static void CreateCommonVBOs(int n) {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        s_nVBOs = new int[1];
        opglGraphics.glGenBuffers(s_nVBOs);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = 1.0f;
        }
        FloatBuffer floatBuffer = FloatBuffer.allocateDirect((int)n);
        floatBuffer.put(0, fArray, 0, fArray.length);
        opglGraphics.glBindBuffer(34962, s_nVBOs[0]);
        opglGraphics.glBufferData(34962, (Buffer)floatBuffer, 35044);
    }

    public static void DestroyCommonVBOs() {
        if (s_nVBOs != null) {
            OpglGraphics opglGraphics = KSGBase.GetGL();
            opglGraphics.glDeleteBuffers(s_nVBOs);
            s_nVBOs = null;
        }
    }

    public Model() {
    }

    public Model(String string) throws IOException {
        this.Create(string);
    }

    public Model(InputStream inputStream) throws IOException {
        this.Create(inputStream);
    }

    public void Create(String string) throws IOException {
        this.Create(Connector.openInputStream((String)string));
    }

    public void Create(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.m_Header = new SFileHeader();
        this.m_Header.Create(dataInputStream);
        this.m_Nodes = new SNodeInfo[this.m_Header.nNodeNum];
        for (int i = 0; i < this.m_Header.nNodeNum; ++i) {
            this.m_Nodes[i] = new SNodeInfo();
            this.m_Nodes[i].Create(dataInputStream);
        }
        OpglGraphics opglGraphics = KSGBase.GetGL();
        int n2 = this.m_Header.nClusterNum > 0 ? 1 : this.m_Header.nVBNum * 2;
        this.m_nVBOs = new int[n2];
        opglGraphics.glGenBuffers(this.m_nVBOs);
        if (this.m_Header.nClusterNum > 0) {
            Object object;
            this.m_Clusters = new SCluster[this.m_Header.nClusterNum];
            for (n = 0; n < this.m_Header.nClusterNum; ++n) {
                object = new SCluster();
                this.m_Clusters[n] = object;
                byte by = dataInputStream.readByte();
                ((SCluster)object).nMatrixIDs = new byte[by];
                for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                    ((SCluster)object).nMatrixIDs[by2] = dataInputStream.readByte();
                }
                ((SCluster)object).nPolyNum = dataInputStream.readShort();
                ((SCluster)object).nOffset = dataInputStream.readShort();
            }
            n = this.m_Header.nPolyNum * 3 * 28;
            object = new byte[n];
            dataInputStream.read((byte[])object);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)n);
            byteBuffer.put(0, (byte[])object, 0, ((Object)object).length);
            opglGraphics.glBindBuffer(34962, this.m_nVBOs[0]);
            opglGraphics.glBufferData(34962, (Buffer)byteBuffer, 35044);
        }
        if (this.m_Header.nMatrixNum > 0) {
            this.m_Matrices = new Matrix44[this.m_Header.nMatrixNum];
            for (n = 0; n < this.m_Header.nMatrixNum; ++n) {
                float f = dataInputStream.readFloat();
                float f2 = dataInputStream.readFloat();
                float f3 = dataInputStream.readFloat();
                float f4 = dataInputStream.readFloat();
                float f5 = dataInputStream.readFloat();
                float f6 = dataInputStream.readFloat();
                float f7 = dataInputStream.readFloat();
                float f8 = dataInputStream.readFloat();
                float f9 = dataInputStream.readFloat();
                float f10 = dataInputStream.readFloat();
                float f11 = dataInputStream.readFloat();
                float f12 = dataInputStream.readFloat();
                float f13 = dataInputStream.readFloat();
                float f14 = dataInputStream.readFloat();
                float f15 = dataInputStream.readFloat();
                float f16 = dataInputStream.readFloat();
                this.m_Matrices[n] = new Matrix44(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
            }
            this.m_MatrixInfos = new SMatrixInfo[this.m_Header.nMatrixNum];
            for (n = 0; n < this.m_Header.nMatrixNum; ++n) {
                this.m_MatrixInfos[n] = new SMatrixInfo();
                this.m_MatrixInfos[n].Create(dataInputStream);
            }
        }
        if (this.m_Header.nPrimNum > 0) {
            this.m_Prims = new SPrimData[this.m_Header.nPrimNum];
            for (n = 0; n < this.m_Header.nPrimNum; ++n) {
                this.m_Prims[n] = new SPrimData();
                this.m_Prims[n].Create(dataInputStream);
            }
        }
        if (this.m_Header.nVBNum > 0) {
            this.m_VBs = new SVBInfo[this.m_Header.nVBNum];
            for (n = 0; n < this.m_Header.nVBNum; ++n) {
                this.m_VBs[n] = new SVBInfo();
                this.m_VBs[n].Create(dataInputStream, this.m_nVBOs[n * 2 + 0], this.m_nVBOs[n * 2 + 1]);
            }
        }
    }

    public void Destroy() {
        if (this.m_nVBOs != null) {
            OpglGraphics opglGraphics = KSGBase.GetGL();
            opglGraphics.glDeleteBuffers(this.m_nVBOs);
            this.m_nVBOs = null;
        }
    }

    public byte GetNodeNum() {
        return this.m_Header.nNodeNum;
    }

    protected byte GetMatrixNum() {
        return this.m_Header.nMatrixNum;
    }

    protected byte GetVBNum() {
        return this.m_Header.nVBNum;
    }

    protected byte GetPrimNum() {
        return this.m_Header.nPrimNum;
    }

    protected byte GetClusterNum() {
        return this.m_Header.nClusterNum;
    }

    private byte GetAlphaPrimNum() {
        return this.m_Header.nAlphaPrimNum;
    }

    public SNodeInfo GetNode(byte by) {
        return this.m_Nodes[by];
    }

    protected Matrix44 GetMatrix(byte by) {
        return this.m_Matrices[by];
    }

    protected SMatrixInfo GetMatrixInfo(byte by) {
        return this.m_MatrixInfos[by];
    }

    protected SVBInfo GetVBInfo(byte by) {
        return this.m_VBs[by];
    }

    protected SPrimData GetPrim(byte by) {
        return this.m_Prims[by];
    }

    protected SCluster GetCluster(byte by) {
        return this.m_Clusters[by];
    }

    protected int GetVBO(int n) {
        return this.m_nVBOs[n];
    }

    static {
        VERTEX_SIZE = new int[]{32, 40, 48, 0, 0, 0, 0, 0, 28, 28};
    }

    class SPrimData {
        public byte[] nMatrixIDs;
        public byte nVBIndex;
        public byte nMatrixNum;
        public byte nTexID;
        public short nStartIndex;
        public short nIndexNum;

        SPrimData() {
        }

        public void Create(DataInputStream dataInputStream) throws IOException {
            this.nMatrixIDs = new byte[8];
            for (int i = 0; i < 8; ++i) {
                this.nMatrixIDs[i] = dataInputStream.readByte();
            }
            this.nMatrixNum = dataInputStream.readByte();
            this.nVBIndex = dataInputStream.readByte();
            this.nTexID = dataInputStream.readByte();
            dataInputStream.skip(1L);
            this.nStartIndex = dataInputStream.readShort();
            this.nIndexNum = dataInputStream.readShort();
        }
    }

    class SVBInfo {
        public byte nType;
        public ByteBuffer vertices;
        public ByteBuffer indices;
        public int nVertexVBO;
        public int nIndexVBO;

        SVBInfo() {
        }

        public int GetVertexSize() {
            return VERTEX_SIZE[this.nType];
        }

        public void Create(DataInputStream dataInputStream, int n, int n2) throws IOException {
            int n3;
            Object object;
            byte[] byArray;
            int n4 = dataInputStream.readShort();
            short s = dataInputStream.readShort();
            this.nType = dataInputStream.readByte();
            dataInputStream.skip(3L);
            int n5 = this.GetVertexSize() * n4;
            if (this.nType != 8) {
                byArray = new byte[n5];
                dataInputStream.read(byArray);
            } else {
                int n6;
                int n7;
                short[] sArray = new short[n4 * 3];
                byte[] byArray2 = new byte[n4 * 3];
                object = new byte[n4 * 2];
                int n8 = 6 * n4 + 3 * n4 + 2 * n4;
                for (n7 = 0; n7 < n4 * 3; ++n7) {
                    sArray[n7] = dataInputStream.readShort();
                }
                dataInputStream.read(byArray2);
                dataInputStream.read((byte[])object);
                n7 = n8 % 4;
                if (n7 != 0) {
                    dataInputStream.skip(4 - n7);
                }
                float[] fArray = new float[n4 * 3];
                float[] fArray2 = new float[n4 * 2];
                for (n6 = 0; n6 < sArray.length; ++n6) {
                    fArray[n6] = sArray[n6];
                }
                for (n6 = 0; n6 < ((byte[])object).length; ++n6) {
                    fArray2[n6] = (float)(object[n6] & 0xFF) / 255.0f;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n4; ++i) {
                    dataOutputStream.writeInt(KSGBase.SwapByte4Float(fArray[i * 3 + 0]));
                    dataOutputStream.writeInt(KSGBase.SwapByte4Float(fArray[i * 3 + 1]));
                    dataOutputStream.writeInt(KSGBase.SwapByte4Float(fArray[i * 3 + 2]));
                    dataOutputStream.writeInt(KSGBase.SwapByte4Float(fArray2[i * 2 + 0]));
                    dataOutputStream.writeInt(KSGBase.SwapByte4Float(fArray2[i * 2 + 1]));
                    dataOutputStream.writeInt(-1);
                    dataOutputStream.writeByte(byArray2[i * 3 + 0]);
                    dataOutputStream.writeByte(byArray2[i * 3 + 1]);
                    dataOutputStream.writeByte(byArray2[i * 3 + 2]);
                    dataOutputStream.writeByte(0);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            this.vertices = ByteBuffer.allocateDirect((int)n5);
            this.vertices.put(0, byArray, 0, byArray.length);
            int n9 = n3 = s * 2;
            byArray = new byte[n9];
            dataInputStream.read(byArray);
            this.indices = ByteBuffer.allocateDirect((int)n3);
            this.indices.put(0, byArray, 0, n3);
            this.nVertexVBO = n;
            this.nIndexVBO = n2;
            object = KSGBase.GetGL();
            object.glBindBuffer(34962, this.nVertexVBO);
            object.glBufferData(34962, (Buffer)this.vertices, 35044);
            object.glBindBuffer(34963, this.nIndexVBO);
            object.glBufferData(34963, (Buffer)this.indices, 35044);
        }
    }

    class SCluster {
        byte[] nMatrixIDs;
        short nPolyNum;
        short nOffset;

        SCluster() {
        }
    }

    class SMatrixInfo {
        public short nNodeID;
        public short nSkeletonID;

        SMatrixInfo() {
        }

        public void Create(DataInputStream dataInputStream) throws IOException {
            this.nNodeID = dataInputStream.readShort();
            this.nSkeletonID = dataInputStream.readShort();
        }
    }

    class SNodeInfo {
        public short nMatrixID;
        public short nParentID;
        public float fRotX;
        public float fRotY;
        public float fRotZ;
        public float fTransX;
        public float fTransY;
        public float fTransZ;

        SNodeInfo() {
        }

        public void Create(DataInputStream dataInputStream) throws IOException {
            this.nMatrixID = dataInputStream.readShort();
            this.nParentID = dataInputStream.readShort();
            this.fRotX = dataInputStream.readFloat();
            this.fRotY = dataInputStream.readFloat();
            this.fRotZ = dataInputStream.readFloat();
            this.fTransX = dataInputStream.readFloat();
            this.fTransY = dataInputStream.readFloat();
            this.fTransZ = dataInputStream.readFloat();
        }
    }

    class SFileHeader {
        public float fMinX;
        public float fMinY;
        public float fMinZ;
        public float fMaxX;
        public float fMaxY;
        public float fMaxZ;
        public byte nNodeNum;
        public byte nMatrixNum;
        public byte nVBNum;
        public byte nPrimNum;
        public byte nAlphaPrimNum;
        public byte nClusterNum;
        public short nPolyNum;

        SFileHeader() {
        }

        public void Create(DataInputStream dataInputStream) throws IOException {
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
            byte by4 = dataInputStream.readByte();
            byte by5 = dataInputStream.readByte();
            byte by6 = dataInputStream.readByte();
            byte by7 = dataInputStream.readByte();
            byte by8 = dataInputStream.readByte();
            this.fMinX = dataInputStream.readFloat();
            this.fMinY = dataInputStream.readFloat();
            this.fMinZ = dataInputStream.readFloat();
            this.fMaxX = dataInputStream.readFloat();
            this.fMaxY = dataInputStream.readFloat();
            this.fMaxZ = dataInputStream.readFloat();
            this.nNodeNum = dataInputStream.readByte();
            if (by7 == 51) {
                this.nClusterNum = dataInputStream.readByte();
                this.nPolyNum = dataInputStream.readShort();
            } else {
                this.nMatrixNum = dataInputStream.readByte();
                this.nVBNum = dataInputStream.readByte();
                this.nPrimNum = dataInputStream.readByte();
                this.nAlphaPrimNum = dataInputStream.readByte();
                dataInputStream.skip(3L);
            }
        }
    }
}

