/*
 * Decompiled with CFR 0.152.
 */
package ksg;

import com.mexa.opgl.OpglGraphics;
import com.mexa.opgl.ShortBuffer;
import java.util.Random;

public class KSGBase {
    private static Random m_Random = new Random();
    public static float TOLERANCE = 1.0E-5f;

    protected static void Init() {
        m_Random.setSeed(System.currentTimeMillis());
    }

    public static OpglGraphics GetGL() {
        return OpglGraphics.getInstance();
    }

    public static ShortBuffer CreateShortBuffer(byte[] byArray) {
        int n = byArray.length >> 1;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)((byArray[i * 2 + 0] & 0xFF) << 8 | byArray[i * 2 + 1] & 0xFF);
        }
        ShortBuffer shortBuffer = ShortBuffer.allocateDirect((int)n);
        shortBuffer.put(0, sArray, 0, sArray.length);
        return shortBuffer;
    }

    public static int RandI() {
        return m_Random.nextInt();
    }

    public static int RandI(int n, int n2) {
        return Math.min(n + m_Random.nextInt(n2 - n + 1), n2);
    }

    public static float RandF() {
        return m_Random.nextFloat();
    }

    public static float RandF(float f, float f2) {
        return Math.min(f + KSGBase.RandF() * (f2 - f), f2);
    }

    public static boolean AlmostEqual(float f, float f2) {
        return Math.abs(f - f2) <= TOLERANCE;
    }

    public static boolean IsAlmostZero(float f) {
        return Math.abs(f) <= TOLERANCE;
    }

    public static int SwapByte4Int(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        return n2 | n3 << 8 | n4 << 16 | n5 << 24;
    }

    public static int SwapByte4Float(float f) {
        return KSGBase.SwapByte4Int(Float.floatToIntBits(f));
    }

    public static short SwapByte4Short(short s) {
        return (short)(s >> 8 | (s & 0xFF) << 8);
    }
}

