/*
 * Decompiled with CFR 0.152.
 */
package ksg;

import com.mexa.opgl.OpglGraphics;
import ksg.KSGBase;
import ksg.Matrix44;
import ksg.Vector3;

public class Camera {
    public Vector3 m_vPos;
    public Vector3 m_vRef;
    public float m_fFov;
    public float[] m_fAspect = new float[2];
    public float m_fSelAspect;
    public float m_fNear;
    public float m_fFar;
    public float m_fFogStart;
    public float m_fFogEnd;
    public float[] m_fFogColor;
    private Matrix44 m_matW2V;
    private Matrix44 m_matV2C;
    private Matrix44 m_matW2C;
    private static int m_nStyle = 1;

    public Camera() {
        float[] fArray = new float[]{1.0f, 1.0f};
        this.Init(fArray);
    }

    public Camera(float[] fArray) {
        this.Init(fArray);
    }

    private void Init(float[] fArray) {
        this.m_fFov = 25.0f;
        for (int i = 0; i < this.m_fAspect.length; ++i) {
            this.m_fAspect[i] = fArray[i];
        }
        this.m_fSelAspect = this.m_fAspect[1];
        this.m_fNear = 1.0f;
        this.m_fFar = 128.0f;
        this.m_fFogEnd = this.m_fFar * 2.0f;
        this.m_fFogStart = this.m_fNear;
        this.m_fFogColor = new float[4];
        this.m_fFogColor[0] = 1.0f;
        this.m_fFogColor[1] = 1.0f;
        this.m_fFogColor[2] = 1.0f;
        this.m_fFogColor[3] = 1.0f;
        this.m_vPos = new Vector3();
        this.m_vRef = new Vector3();
        this.m_matW2V = new Matrix44();
        this.m_matV2C = new Matrix44();
        this.m_matW2C = new Matrix44();
        this.m_vPos.z = 9.0f;
        this.m_vPos.y = 2.5f;
        this.m_vRef.y = 1.5f;
        this.UpdateW2VMatrix();
        this.UpdateV2CMatrix();
    }

    public void UpdateW2VMatrix() {
        Vector3 vector3 = Vector3.Push();
        vector3.Sub(this.m_vPos, this.m_vRef);
        Matrix44 matrix44 = Matrix44.Push();
        matrix44.MakeRotMatrix(vector3);
        matrix44.SetRow(3, this.m_vPos);
        Vector3.Pop(1);
        this.m_matW2V.InvertRT(matrix44);
        Matrix44.Pop(1);
        this.UpdateW2CMatrix();
    }

    public void UpdateV2CMatrix() {
        Matrix44 matrix44 = this.m_matV2C;
        float f = 1.0f / (float)Math.tan(Math.toRadians(this.m_fFov) * 0.5);
        float f2 = -1.0f / (this.m_fFar - this.m_fNear);
        matrix44.SetM00(f / this.m_fSelAspect);
        matrix44.SetM11(f);
        matrix44.SetM22((this.m_fFar + this.m_fNear) * f2);
        matrix44.SetM32(2.0f * this.m_fFar * this.m_fNear * f2);
        matrix44.SetM23(-1.0f);
        this.UpdateW2CMatrix();
    }

    private void UpdateW2CMatrix() {
        this.m_matW2C.Mul(this.m_matW2V, this.m_matV2C);
    }

    public void Apply() {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glFogf(2917, 9729.0f);
        opglGraphics.glFogf(2915, this.m_fFogStart);
        opglGraphics.glFogf(2916, this.m_fFogEnd);
        opglGraphics.glFogfv(2918, this.m_fFogColor);
        opglGraphics.glMatrixMode(5889);
        opglGraphics.glLoadMatrixf(this.m_matV2C.GetElems());
        if (m_nStyle == 0) {
            opglGraphics.glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
            this.m_fSelAspect = this.m_fAspect[0];
        } else {
            this.m_fSelAspect = this.m_fAspect[1];
        }
        opglGraphics.glMatrixMode(5888);
        opglGraphics.glLoadMatrixf(this.m_matW2V.GetElems());
    }

    public void ApplyConst() {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glFogf(2917, 9729.0f);
        opglGraphics.glFogf(2915, this.m_fFogStart);
        opglGraphics.glFogf(2916, this.m_fFogEnd);
        opglGraphics.glFogfv(2918, this.m_fFogColor);
        opglGraphics.glMatrixMode(5889);
        opglGraphics.glLoadMatrixf(this.m_matV2C.GetElems());
        opglGraphics.glMatrixMode(5888);
        opglGraphics.glLoadMatrixf(this.m_matW2V.GetElems());
    }

    public void AddRotation(float f, float f2) {
        Vector3 vector3 = Vector3.Push();
        vector3.Sub(this.m_vRef, this.m_vPos);
        Matrix44 matrix44 = Matrix44.Push();
        matrix44.MakeRotMatrix(vector3);
        Matrix44 matrix442 = Matrix44.Push();
        matrix442.Transpose(matrix44);
        Matrix44 matrix443 = Matrix44.Push();
        matrix443.RotX(-f);
        Matrix44 matrix444 = Matrix44.Push();
        matrix444.RotY(-f2);
        matrix442.Mul(matrix443);
        matrix442.Mul(matrix444);
        matrix44.Mul(matrix442, matrix44);
        matrix44.Apply(vector3);
        this.m_vPos.Sub(this.m_vRef, vector3);
        Matrix44.Pop(4);
        Vector3.Pop(1);
        this.UpdateW2VMatrix();
    }

    public void AddDistance(float f) {
        Vector3 vector3 = Vector3.Push();
        vector3.Sub(this.m_vPos, this.m_vRef);
        vector3.Scale(f);
        this.m_vPos.Add(vector3);
        Vector3.Pop(1);
        this.UpdateW2VMatrix();
    }

    public Matrix44 GetW2VMatrix() {
        return this.m_matW2V;
    }

    public Matrix44 GetV2CMatrix() {
        return this.m_matV2C;
    }

    public Matrix44 GetW2CMatrix() {
        return this.m_matW2C;
    }

    public static int SetStyle(int n) {
        m_nStyle = n;
        return m_nStyle;
    }

    public static int GetStyle() {
        return m_nStyle;
    }
}

