/*
 * Decompiled with CFR 0.152.
 */
import ksg.Matrix44;
import ksg.TriFunc;
import ksg.Vector3;

public class Transform
extends Matrix44 {
    public Transform() {
        this.SetIdentity();
    }

    public Transform(Transform transform) {
        this.Set(transform);
    }

    public void setIdentity() {
        this.SetIdentity();
    }

    public void transpose() {
        this.Transpose();
    }

    public void multiply(Transform transform) {
        this.Mul(this, transform);
    }

    public void scale(float f, float f2, float f3) {
        this.SetM00(this.GetM00() * f);
        this.SetM01(this.GetM01() * f2);
        this.SetM02(this.GetM02() * f3);
        this.SetM10(this.GetM10() * f);
        this.SetM11(this.GetM11() * f2);
        this.SetM12(this.GetM12() * f3);
        this.SetM20(this.GetM20() * f);
        this.SetM21(this.GetM21() * f2);
        this.SetM22(this.GetM22() * f3);
        this.SetM30(this.GetM30() * f);
        this.SetM31(this.GetM31() * f2);
        this.SetM32(this.GetM32() * f3);
    }

    public void scale(Vector3D vector3D) {
        this.scale(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public void rotate(float f, float f2, float f3, float f4) {
        Matrix44 matrix44 = Matrix44.Push();
        float f5 = TriFunc.Cos360(f4);
        float f6 = TriFunc.Sin360(f4);
        float f7 = 1.0f - f5;
        matrix44.Set(f * f * f7 + f5, f2 * f * f7 + f3 * f6, f2 * f3 * f7 - f2 * f6, 0.0f, f * f2 * f7 - f3 * f6, f2 * f2 * f7 + f5, f2 * f3 * f7 + f * f6, 0.0f, f * f3 * f7 + f2 * f6, f2 * f3 * f7 - f * f6, f3 * f3 * f7 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.Mul(matrix44, this);
        Matrix44.Pop(1);
    }

    public void rotXY(float f, float f2) {
        float f3 = TriFunc.Cos4096(f);
        float f4 = TriFunc.Sin4096(f);
        float f5 = 1.0f - f3;
        float f6 = TriFunc.Cos4096(f2);
        float f7 = TriFunc.Sin4096(f2);
        float f8 = 1.0f - f6;
        this.Set((f5 + f3) * f6, -1.0f * f4 * f7, -1.0f * f3 * f7, 0.0f, 0.0f, f3 * (f8 + f6), f4 * (f8 + f6), 0.0f, (f5 + f3) * f7, -1.0f * f4 * f6, f3 * f6, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotYX(float f, float f2) {
        float f3 = TriFunc.Cos4096(f2);
        float f4 = TriFunc.Sin4096(f2);
        float f5 = 1.0f - f3;
        float f6 = TriFunc.Cos4096(f);
        float f7 = TriFunc.Sin4096(f);
        float f8 = 1.0f - f6;
        this.Set(f6 * (f5 + f3), 0.0f, -1.0f * f7 * (f5 + f3), 0.0f, f7 * f4, (f8 + f6) * f3, f6 * f4, 0.0f, f7 * f3, -1.0f * (f8 + f6) * f4, f6 * f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotXYtrsXYZ(float f, float f2, float f3, float f4, float f5) {
        float f6 = TriFunc.Cos4096(f);
        float f7 = TriFunc.Sin4096(f);
        float f8 = 1.0f - f6;
        float f9 = TriFunc.Cos4096(f2);
        float f10 = TriFunc.Sin4096(f2);
        float f11 = 1.0f - f9;
        this.Set((f8 + f6) * f9, -1.0f * f7 * f10, -1.0f * f6 * f10, 0.0f, 0.0f, f6 * (f11 + f9), f7 * (f11 + f9), 0.0f, (f8 + f6) * f10, -1.0f * f7 * f9, f6 * f9, 0.0f, f3, f4, f5, 1.0f);
    }

    public void rotXYtrsXYZ2(float f, float f2, float f3, float f4, float f5) {
        float f6 = TriFunc.Cos4096(f);
        float f7 = TriFunc.Sin4096(f);
        float f8 = 1.0f - f6;
        float f9 = TriFunc.Cos4096(f2);
        float f10 = TriFunc.Sin4096(f2);
        float f11 = 1.0f - f9;
        this.Set((f8 + f6) * f9 * -1.0f, -1.0f * f7 * f10 * -1.0f, -1.0f * f6 * f10 * -1.0f, 0.0f, 0.0f, f6 * (f11 + f9), f7 * (f11 + f9), 0.0f, (f8 + f6) * f10, -1.0f * f7 * f9, f6 * f9, 0.0f, f3, f4, f5, 1.0f);
    }

    public void rotXYtrsXYZsclXYZ(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = TriFunc.Cos360(f);
        float f10 = TriFunc.Sin360(f);
        float f11 = 1.0f - f9;
        float f12 = TriFunc.Cos360(f2);
        float f13 = TriFunc.Sin360(f2);
        float f14 = 1.0f - f12;
        this.Set((f11 + f9) * f12 * f6, -1.0f * f10 * f13 * f7, -1.0f * f9 * f13 * f8, 0.0f, 0.0f, f9 * (f14 + f12) * f6, f10 * (f14 + f12) * f7, 0.0f, (f11 + f9) * f13 * f6, -1.0f * f10 * f12 * f7, f9 * f12 * f8, 0.0f, f3 * f6, f4 * f7, f5 * f8, 1.0f);
    }

    public void rotYsclXYZtrsXYZ(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = TriFunc.Cos4096(f);
        float f9 = TriFunc.Sin4096(f);
        float f10 = 1.0f - f8;
        this.Set(f8 * f2, 0.0f, -f9 * f4, 0.0f, 0.0f, (f10 + f8) * f3, 0.0f, 0.0f, f9 * f2, 0.0f, f8 * f4, 0.0f, f5, f6, f7, 1.0f);
    }

    public void rotYsclXYZtrsXYZ2(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = TriFunc.Cos4096(f);
        float f9 = TriFunc.Sin4096(f);
        float f10 = 1.0f - f8;
        this.Set(f8 * f2, 0.0f, -f9 * f4, 0.0f, 0.0f, (f10 + f8) * f3, 0.0f, 0.0f, f9 * f2 * -1.0f, 0.0f, f8 * f4 * -1.0f, 0.0f, f5, f6, f7, 1.0f);
    }

    public void rotYtrsXYZ(float f, float f2, float f3, float f4) {
        float f5 = TriFunc.Cos4096(f);
        float f6 = TriFunc.Sin4096(f);
        float f7 = 1.0f - f5;
        this.Set(f5, 0.0f, -f6, 0.0f, 0.0f, f7 + f5, 0.0f, 0.0f, f6, 0.0f, f5, 0.0f, f2, f3, f4, 1.0f);
    }

    public void rotYtrsXYZ2(float f, float f2, float f3, float f4) {
        float f5 = TriFunc.Cos4096(f);
        float f6 = TriFunc.Sin4096(f);
        float f7 = 1.0f - f5;
        this.Set(f5, 0.0f, -f6, 0.0f, 0.0f, f7 + f5, 0.0f, 0.0f, f6 * -1.0f, 0.0f, f5 * -1.0f, 0.0f, f2, f3, f4, 1.0f);
    }

    public void rotXYsclXYZtrsXYZ(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = TriFunc.Cos4096(f);
        float f10 = TriFunc.Sin4096(f);
        float f11 = 1.0f - f9;
        float f12 = TriFunc.Cos4096(f2);
        float f13 = TriFunc.Sin4096(f2);
        float f14 = 1.0f - f12;
        this.Set((f11 + f9) * f12 * f3, -1.0f * f10 * f13 * f4, -1.0f * f9 * f13 * f5, 0.0f, 0.0f, f9 * (f14 + f12) * f4, f10 * (f14 + f12) * f5, 0.0f, (f11 + f9) * f13 * f3, -1.0f * f10 * f12 * f4, f9 * f12 * f5, 0.0f, f6, f7, f8, 1.0f);
    }

    public void sclXYZtrsXYZ(float f, float f2, float f3, float f4, float f5, float f6) {
        this.Set(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, f3, 0.0f, f4, f5, f6, 1.0f);
    }

    public void sclXYZtrsXYZ2(float f, float f2, float f3, float f4, float f5, float f6) {
        this.Set(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, f3 * -1.0f, 0.0f, f4, f5, f6, 1.0f);
    }

    public void rotate(Vector3D vector3D, float f) {
        this.rotate(vector3D.getX(), vector3D.getY(), vector3D.getZ(), f);
    }

    public void translate(float f, float f2, float f3) {
        Matrix44 matrix44 = Matrix44.Push();
        matrix44.SetIdentity();
        matrix44.SetRow(3, f, f2, f3);
        this.Mul(matrix44);
        Matrix44.Pop(1);
    }

    public void translate(Vector3D vector3D) {
        this.translate(vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public void lookAt(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3 vector3 = Vector3.Push();
        vector3.Sub(vector3D, vector3D2);
        Matrix44 matrix44 = Matrix44.Push();
        matrix44.MakeRotMatrix(vector3);
        matrix44.SetRow(3, vector3D);
        Vector3.Pop(1);
        this.InvertRT(matrix44);
        Matrix44.Pop(1);
    }

    public void transVector(Vector3D vector3D, Vector3D vector3D2) {
        vector3D2.Set(vector3D);
        this.Apply34(vector3D2);
    }

    public void invert() {
        this.Invert(this);
    }

    public void set(Transform transform) {
        this.set(transform.m_fElems);
    }

    public void get(float[] fArray) {
        for (int i = 0; i < 16; ++i) {
            fArray[i / 4 + i % 4 * 4] = this.m_fElems[i];
        }
    }

    public void set(float[] fArray) {
        for (int i = 0; i < 16; ++i) {
            this.m_fElems[i] = fArray[i / 4 + i % 4 * 4];
        }
    }
}

