/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;

public class ScratchPad {
    static final int SAVE_SIZE = 34613;
    static final String fileName = "musou";
    private static byte[] data = new byte[34613];
    private static int offset = 0;

    public static void initread() throws Exception {
        RecordStore recordStore = null;
        recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
        if (recordStore.getNumRecords() > 0) {
            data = recordStore.getRecord(1);
        }
        recordStore.closeRecordStore();
    }

    public static void format() {
        for (int i = 0; i < data.length; ++i) {
            ScratchPad.data[i] = 0;
        }
        try {
            ScratchPad.update();
        }
        catch (Exception exception) {
            Gb.tr("format err : " + exception.toString());
        }
    }

    public static void update() throws Exception {
        RecordStore recordStore = null;
        recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
        if (recordStore.getNumRecords() > 0) {
            recordStore.setRecord(1, data, 0, data.length);
        } else {
            recordStore.addRecord(data, 0, data.length);
        }
        recordStore.closeRecordStore();
    }

    public static void set(int n) throws Exception {
        offset = n;
    }

    public static void skip(int n) throws Exception {
        ScratchPad.checkDataSize(n);
        offset += n;
    }

    public static void checkDataSize(int n) throws Exception {
        if (offset + n >= 34613) {
            throw new Exception("\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093");
        }
    }

    public static byte[] getBytes() {
        return data;
    }

    public static boolean readBoolean() throws Exception {
        ScratchPad.checkDataSize(1);
        return data[offset++] == 1;
    }

    public static byte readByte() throws Exception {
        ScratchPad.checkDataSize(1);
        return data[offset++];
    }

    public static short readShort() throws Exception {
        ScratchPad.checkDataSize(2);
        return (short)((0xFF00 & data[offset++] << 8 | 0xFF & data[offset++]) & 0xFFFF);
    }

    public static int readInt() throws Exception {
        ScratchPad.checkDataSize(4);
        return 0xFF000000 & data[offset++] << 24 | 0xFF0000 & data[offset++] << 16 | 0xFF00 & data[offset++] << 8 | 0xFF & data[offset++];
    }

    public static void writeBoolean(boolean bl) throws Exception {
        ScratchPad.checkDataSize(1);
        ScratchPad.data[ScratchPad.offset++] = bl ? (byte)1 : 0;
    }

    public static void writeByte(int n) throws Exception {
        ScratchPad.writeByte((byte)n);
    }

    public static void writeByte(byte by) throws Exception {
        ScratchPad.checkDataSize(1);
        ScratchPad.data[ScratchPad.offset++] = by;
    }

    public static void writeShort(int n) throws Exception {
        ScratchPad.writeShort((short)n);
    }

    public static void writeShort(short s) throws Exception {
        ScratchPad.checkDataSize(2);
        ScratchPad.data[ScratchPad.offset++] = (byte)(s >> 8 & 0xFF);
        ScratchPad.data[ScratchPad.offset++] = (byte)(s & 0xFF);
    }

    public static void writeInt(int n) throws Exception {
        ScratchPad.checkDataSize(4);
        ScratchPad.data[ScratchPad.offset++] = (byte)(n >> 24 & 0xFF);
        ScratchPad.data[ScratchPad.offset++] = (byte)(n >> 16 & 0xFF);
        ScratchPad.data[ScratchPad.offset++] = (byte)(n >> 8 & 0xFF);
        ScratchPad.data[ScratchPad.offset++] = (byte)(n & 0xFF);
    }

    public static float readFloat() throws Exception {
        ScratchPad.checkDataSize(4);
        return Float.intBitsToFloat(ScratchPad.readInt());
    }

    public static void writeFloat(float f) throws Exception {
        ScratchPad.checkDataSize(4);
        ScratchPad.writeInt(Float.floatToIntBits(f));
    }
}

