/*
 * Decompiled with CFR 0.152.
 */
import com.mexa.opgl.Buffer;
import com.mexa.opgl.FloatBuffer;
import com.mexa.opgl.OpglGraphics;
import javax.microedition.lcdui.Graphics;
import ksg.Camera;
import ksg.KSGBase;
import ksg.KSGSystem;
import ksg.Texture;
import ksg.TriFunc;

class Rect3D {
    private static final int nVertexNum = 4;
    private static final int margin = 5;
    private static final int nCircleVertexNum = 74;
    protected static int[] m_nVBOs;
    protected static final int VBO_VERTEX = 0;
    protected static final int VBO_CIRCLE_VERTEX = 1;
    protected static final int VBO_COLORVERTEX = 2;
    protected static final int VBO_CIRCLE_COLORVERTEX = 3;
    protected static final int VBO_CIRCLE_TEXCOORDS = 4;
    protected static final int VBO_TEXCOORDS = 5;
    protected static final int VBO_NUM = 6;
    protected static int colorPattern;
    protected static float[] fVertices;
    protected static float[] fColorVertices;
    protected static float[] fTexCoords;
    protected static FloatBuffer buff;
    protected static FloatBuffer ColorBuff;
    protected static FloatBuffer TexBuff;
    static float[] fCircleVertices;
    static float[] fCircleColorVertices;
    static float[] fCircleTexCoords;
    protected static FloatBuffer circleVertices;
    protected static FloatBuffer circleColorVertices;
    protected static FloatBuffer circleTexcoords;
    protected static Camera m_Camera;
    protected static float r_width;
    protected static float r_height;
    protected static Transform tmpMtx;
    static int offset_x;
    static int offset_y;
    static float[] move;

    Rect3D() {
    }

    public static float getWidth() {
        return r_width;
    }

    public static float getHeight() {
        return r_height;
    }

    public static void init() {
        m_nVBOs = new int[6];
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glGenBuffers(m_nVBOs);
        opglGraphics.glBindBuffer(34962, m_nVBOs[0]);
        opglGraphics.glBufferData(34962, (Buffer)buff, 35048);
        opglGraphics.glBindBuffer(34962, m_nVBOs[1]);
        opglGraphics.glBufferData(34962, (Buffer)circleVertices, 35048);
        opglGraphics.glBindBuffer(34962, m_nVBOs[2]);
        opglGraphics.glBufferData(34962, (Buffer)ColorBuff, 35048);
        opglGraphics.glBindBuffer(34962, m_nVBOs[3]);
        opglGraphics.glBufferData(34962, (Buffer)circleColorVertices, 35048);
        opglGraphics.glBindBuffer(34962, m_nVBOs[4]);
        opglGraphics.glBufferData(34962, (Buffer)circleTexcoords, 35048);
        opglGraphics.glBindBuffer(34962, m_nVBOs[5]);
        opglGraphics.glBufferData(34962, (Buffer)TexBuff, 35048);
    }

    public static void updateCamera(float f, float f2) {
        if (r_width == f && r_height == f2) {
            return;
        }
        r_width = f;
        r_height = f2;
        float[] fArray = new float[]{r_width / r_height, r_width / r_height};
        m_Camera = new Camera(fArray);
        Rect3D.m_Camera.m_vPos.Set(0.0f, 0.0f, 1.001f);
        Rect3D.m_Camera.m_vRef.Set(0.0f, 0.0f, 0.0f);
        m_Camera.UpdateW2VMatrix();
        Rect3D.m_Camera.m_fNear = 1.0f;
        Rect3D.m_Camera.m_fFar = 500.0f;
        Rect3D.m_Camera.m_fFov = 43.0f;
        m_Camera.UpdateV2CMatrix();
        m_Camera.Apply();
    }

    public static void translateOffset(int n, int n2) {
        offset_x = n;
        offset_y = n2;
    }

    public static void resetOffset() {
        offset_x = 0;
        offset_y = 0;
    }

    public static void drawRect3D(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        n += offset_x;
        n2 += offset_y;
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.bind((Object)graphics);
        opglGraphics.glPushMatrix();
        KSGSystem.BeginRender();
        opglGraphics.glClear(256);
        opglGraphics.glDisable(3553);
        opglGraphics.glDisable(2896);
        float f = Rect3D.getAspectRate();
        Rect3D.setVertices(fVertices, 0, n, n2, f);
        Rect3D.setVertices(fVertices, 3, n + n3, n2, f);
        Rect3D.setVertices(fVertices, 6, n, n2 + n4, f);
        Rect3D.setVertices(fVertices, 9, n + n3, n2 + n4, f);
        Rect3D.setSameColorVertices(fColorVertices, 0, 4, n5, n6);
        m_Camera.ApplyConst();
        buff.put(0, fVertices, 0, 12);
        ColorBuff.put(0, fColorVertices, 0, 4 * colorPattern);
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, m_nVBOs[0]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)buff);
        opglGraphics.glVertexPointer(3, 5126, 0, 0);
        opglGraphics.glEnableClientState(32886);
        opglGraphics.glBindBuffer(34962, m_nVBOs[2]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)ColorBuff);
        opglGraphics.glColorPointer(colorPattern, 5126, 0, 0);
        opglGraphics.glBlendFunc(768, 771);
        opglGraphics.glEnable(3042);
        opglGraphics.glMatrixMode(5888);
        tmpMtx.SetIdentity();
        opglGraphics.glMultMatrixf(tmpMtx.GetElems());
        opglGraphics.glDrawArrays(5, 0, 4);
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glDisableClientState(32886);
        opglGraphics.glDisable(3042);
        opglGraphics.glEnable(2896);
        opglGraphics.glPopMatrix();
        KSGSystem.EndRender();
        opglGraphics.release();
    }

    public static float getAspectRate() {
        return TriFunc.Tan360(Rect3D.m_Camera.m_fFov / 2.0f) * Rect3D.m_Camera.m_fNear * 2.0f;
    }

    public static void setVertices(float[] fArray, int n, float f, float f2, float f3) {
        fArray[n] = -1.0f * f3 / 2.0f * Rect3D.m_Camera.m_fSelAspect * (1.0f - f * 2.0f / Rect3D.getWidth());
        fArray[n + 1] = 1.0f * f3 / 2.0f * (1.0f - f2 * 2.0f / Rect3D.getHeight());
        fArray[n + 2] = 0.0f;
    }

    public static void setTexCoords(float[] fArray, int n, float f, float f2) {
        fArray[n] = f;
        fArray[n + 1] = f2;
    }

    public static void setSameColorVertices(float[] fArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i * Rect3D.colorPattern] = (float)(n3 >> 16 & 0xFF) / 255.0f;
            fArray[n + i * Rect3D.colorPattern + 1] = (float)(n3 >> 8 & 0xFF) / 255.0f;
            fArray[n + i * Rect3D.colorPattern + 2] = (float)(n3 & 0xFF) / 255.0f;
            if (colorPattern != 4) continue;
            fArray[n + i * Rect3D.colorPattern + 3] = (float)n4 / 255.0f;
        }
    }

    public static void drawCircle3D(Graphics graphics, float f, float f2, int n, int n2, int n3) {
        f += (float)offset_x;
        f2 += (float)offset_y;
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.bind((Object)graphics);
        opglGraphics.glPushMatrix();
        KSGSystem.BeginRender();
        opglGraphics.glClear(256);
        opglGraphics.glDisable(3553);
        opglGraphics.glDisable(2896);
        float f3 = Rect3D.getAspectRate();
        int n4 = 1;
        Rect3D.setVertices(fCircleVertices, 0, f, f2, f3);
        for (int i = 0; i <= 360; i += 5) {
            Rect3D.setVertices(fCircleVertices, n4 * 3, f + TriFunc.Cos360(i) * (float)n, f2 + TriFunc.Sin360(i) * (float)n, f3);
            ++n4;
        }
        Rect3D.setSameColorVertices(fCircleColorVertices, 0, n4, n2, n3);
        m_Camera.ApplyConst();
        circleVertices.put(0, fCircleVertices, 0, n4 * 3);
        circleColorVertices.put(0, fCircleColorVertices, 0, n4 * colorPattern);
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, m_nVBOs[1]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)circleVertices);
        opglGraphics.glVertexPointer(3, 5126, 0, 0);
        opglGraphics.glEnableClientState(32886);
        opglGraphics.glBindBuffer(34962, m_nVBOs[3]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)circleColorVertices);
        opglGraphics.glColorPointer(colorPattern, 5126, 0, 0);
        opglGraphics.glBlendFunc(770, 771);
        opglGraphics.glEnable(3042);
        opglGraphics.glMatrixMode(5888);
        tmpMtx.SetIdentity();
        opglGraphics.glMultMatrixf(tmpMtx.GetElems());
        opglGraphics.glDrawArrays(6, 0, n4);
        opglGraphics.glPopMatrix();
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glDisableClientState(32886);
        opglGraphics.glDisable(3042);
        opglGraphics.glEnable(2896);
        KSGSystem.EndRender();
        opglGraphics.release();
    }

    public static void drawCircleTexture(Graphics graphics, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        f4 += (float)offset_x;
        f5 += (float)offset_y;
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.bind((Object)graphics);
        opglGraphics.glPushMatrix();
        KSGSystem.BeginRender();
        opglGraphics.glClear(256);
        opglGraphics.glDisable(2896);
        float f9 = Rect3D.getAspectRate();
        int n = 1;
        Rect3D.setTexCoords(fCircleTexCoords, 0, f, f2);
        Rect3D.setVertices(fCircleVertices, 0, f4, f5, f9);
        for (int i = 0; i <= 360; i += 5) {
            Rect3D.setTexCoords(fCircleTexCoords, n * 2, f + TriFunc.Cos360((float)i + f8) * f3, f2 + TriFunc.Sin360((float)i + f8) * f3);
            Rect3D.setVertices(fCircleVertices, n * 3, f4 + TriFunc.Cos360(i) * f6, f5 + TriFunc.Sin360(i) * f6, f9);
            ++n;
        }
        m_Camera.ApplyConst();
        circleVertices.put(0, fCircleVertices, 0, n * 3);
        circleTexcoords.put(0, fCircleTexCoords, 0, n * 2);
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, m_nVBOs[1]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)circleVertices);
        opglGraphics.glVertexPointer(3, 5126, 0, 0);
        opglGraphics.glEnableClientState(32888);
        opglGraphics.glBindBuffer(34962, m_nVBOs[4]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)circleTexcoords);
        opglGraphics.glTexCoordPointer(2, 5126, 0, 0);
        opglGraphics.glEnable(3553);
        opglGraphics.glColor4f(1.0f, 1.0f, 1.0f, f7);
        opglGraphics.glBlendFunc(768, 774);
        opglGraphics.glEnable(3042);
        texture.Bind();
        opglGraphics.glMatrixMode(5888);
        tmpMtx.SetIdentity();
        opglGraphics.glMultMatrixf(tmpMtx.GetElems());
        opglGraphics.glDrawArrays(6, 0, n);
        opglGraphics.glPopMatrix();
        opglGraphics.glDisableClientState(32888);
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glDisable(3042);
        opglGraphics.glEnable(2896);
        KSGSystem.EndRender();
        opglGraphics.release();
    }

    public static void drawRectTex3D(Graphics graphics, Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        f5 += (float)offset_x;
        f6 += (float)offset_y;
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.bind((Object)graphics);
        opglGraphics.glPushMatrix();
        KSGSystem.BeginRender();
        opglGraphics.glClear(256);
        opglGraphics.glDisable(2896);
        float f11 = Rect3D.getAspectRate();
        Rect3D.setTexCoords(fTexCoords, 0, f, f2);
        Rect3D.setTexCoords(fTexCoords, 2, f + f3, f2);
        Rect3D.setTexCoords(fTexCoords, 4, f, f2 + f4);
        Rect3D.setTexCoords(fTexCoords, 6, f + f3, f2 + f4);
        if (bl) {
            Rect3D.setVertices(fVertices, 0, Rect3D.getWidth() / 2.0f - f7 / 2.0f, Rect3D.getHeight() / 2.0f - f8 / 2.0f, f11);
            Rect3D.setVertices(fVertices, 3, Rect3D.getWidth() / 2.0f + f7 / 2.0f, Rect3D.getHeight() / 2.0f - f8 / 2.0f, f11);
            Rect3D.setVertices(fVertices, 6, Rect3D.getWidth() / 2.0f - f7 / 2.0f, Rect3D.getHeight() / 2.0f + f8 / 2.0f, f11);
            Rect3D.setVertices(fVertices, 9, Rect3D.getWidth() / 2.0f + f7 / 2.0f, Rect3D.getHeight() / 2.0f + f8 / 2.0f, f11);
            Rect3D.setVertices(move, 0, f5 + f7 / 2.0f, f6 + f8 / 2.0f, f11);
            Rect3D.setVertices(move, 3, Rect3D.getWidth() / 2.0f, Rect3D.getHeight() / 2.0f, f11);
        } else {
            Rect3D.setVertices(fVertices, 0, Rect3D.getWidth() / 2.0f, Rect3D.getHeight() / 2.0f, f11);
            Rect3D.setVertices(fVertices, 3, Rect3D.getWidth() / 2.0f + f7, Rect3D.getHeight() / 2.0f, f11);
            Rect3D.setVertices(fVertices, 6, Rect3D.getWidth() / 2.0f, Rect3D.getHeight() / 2.0f + f8, f11);
            Rect3D.setVertices(fVertices, 9, Rect3D.getWidth() / 2.0f + f7, Rect3D.getHeight() / 2.0f + f8, f11);
            Rect3D.setVertices(move, 0, f5, f6, f11);
            Rect3D.setVertices(move, 3, Rect3D.getWidth() / 2.0f, Rect3D.getHeight() / 2.0f, f11);
        }
        m_Camera.ApplyConst();
        opglGraphics.glEnable(3553);
        opglGraphics.glColor4f(1.0f, 1.0f, 1.0f, f9);
        opglGraphics.glBlendFunc(768, 774);
        opglGraphics.glEnable(3042);
        texture.Bind();
        buff.put(0, fVertices, 0, 12);
        TexBuff.put(0, fTexCoords, 0, 8);
        opglGraphics.glEnableClientState(32888);
        opglGraphics.glBindBuffer(34962, m_nVBOs[5]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)TexBuff);
        opglGraphics.glTexCoordPointer(2, 5126, 0, 0);
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, m_nVBOs[0]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)buff);
        opglGraphics.glVertexPointer(3, 5126, 0, 0);
        opglGraphics.glMatrixMode(5888);
        tmpMtx.SetIdentity();
        tmpMtx.rotate(0.0f, 0.0f, 1.0f, f10 * 360.0f / 4096.0f);
        tmpMtx.translate(move[0] - move[3], move[1] - move[4], move[2] - move[5]);
        opglGraphics.glMultMatrixf(tmpMtx.GetElems());
        opglGraphics.glDrawArrays(5, 0, 4);
        opglGraphics.glDisableClientState(32888);
        opglGraphics.glDisableClientState(32884);
        opglGraphics.glDisable(3042);
        opglGraphics.glEnable(2896);
        opglGraphics.glPopMatrix();
        KSGSystem.EndRender();
        opglGraphics.release();
    }

    static {
        colorPattern = 4;
        fVertices = new float[12];
        fColorVertices = new float[4 * colorPattern];
        fTexCoords = new float[8];
        buff = FloatBuffer.allocateDirect((int)fVertices.length);
        ColorBuff = FloatBuffer.allocateDirect((int)fColorVertices.length);
        TexBuff = FloatBuffer.allocateDirect((int)fTexCoords.length);
        fCircleVertices = new float[222];
        fCircleColorVertices = new float[74 * colorPattern];
        fCircleTexCoords = new float[148];
        circleVertices = FloatBuffer.allocateDirect((int)fCircleVertices.length);
        circleColorVertices = FloatBuffer.allocateDirect((int)fCircleColorVertices.length);
        circleTexcoords = FloatBuffer.allocateDirect((int)fCircleTexCoords.length);
        tmpMtx = new Transform();
        offset_x = 0;
        offset_y = 0;
        move = new float[6];
    }
}

