/*
 * Decompiled with CFR 0.152.
 */
import com.mexa.opgl.Buffer;
import com.mexa.opgl.FloatBuffer;
import com.mexa.opgl.OpglGraphics;
import ksg.KSGBase;
import ksg.Texture;

public class Primitive {
    public static int PLANE_VERTEX_NUM = 18;
    public static int PLANE_TEXCODE_NUM = 12;
    private static float[] m_fVertex;
    private static float[] m_fTexCood;
    protected static final int VBO_VERTEX = 0;
    protected static final int VBO_TEXCOORD = 1;
    protected static final int VBO_NUM = 2;
    protected static int[] m_nVBOs;
    protected static FloatBuffer m_Vertex;
    protected static FloatBuffer m_TexCood;

    public static void Init() {
        m_fVertex = new float[64 * PLANE_VERTEX_NUM];
        m_fTexCood = new float[64 * PLANE_TEXCODE_NUM];
        m_Vertex = FloatBuffer.allocateDirect((int)(64 * PLANE_VERTEX_NUM));
        m_TexCood = FloatBuffer.allocateDirect((int)(64 * PLANE_TEXCODE_NUM));
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glGenBuffers(m_nVBOs);
        opglGraphics.glBindBuffer(34962, m_nVBOs[0]);
        opglGraphics.glBufferData(34962, (Buffer)m_Vertex, 35048);
        opglGraphics.glBindBuffer(34962, m_nVBOs[1]);
        opglGraphics.glBufferData(34962, (Buffer)m_TexCood, 35048);
    }

    public static void Destroy() {
        if (m_nVBOs != null) {
            OpglGraphics opglGraphics = KSGBase.GetGL();
            opglGraphics.glDeleteBuffers(m_nVBOs);
            m_nVBOs = null;
        }
    }

    public static void RenderPrimitive(int n, Texture texture, Transform transform) {
        if (n == 0) {
            return;
        }
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glDisable(2896);
        opglGraphics.glEnable(3553);
        texture.Bind();
        m_Vertex.put(0, m_fVertex, 0, n * PLANE_VERTEX_NUM);
        m_TexCood.put(0, m_fTexCood, 0, n * PLANE_TEXCODE_NUM);
        opglGraphics.glEnableClientState(32884);
        opglGraphics.glBindBuffer(34962, m_nVBOs[0]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)m_Vertex);
        opglGraphics.glVertexPointer(3, 5126, 0, 0);
        opglGraphics.glEnableClientState(32888);
        opglGraphics.glBindBuffer(34962, m_nVBOs[1]);
        opglGraphics.glBufferSubData(34962, 0, (Buffer)m_TexCood);
        opglGraphics.glTexCoordPointer(2, 5126, 0, 0);
        opglGraphics.glMatrixMode(5888);
        opglGraphics.glPushMatrix();
        opglGraphics.glMultMatrixf(transform.GetElems());
        opglGraphics.glDrawArrays(4, 0, n * 3 * 2);
        opglGraphics.glPopMatrix();
        opglGraphics.glDisableClientState(32888);
        opglGraphics.glDisableClientState(32884);
    }

    public static void debugInfo(int n) {
        int n2;
        for (n2 = 0; n2 < PLANE_VERTEX_NUM * n; ++n2) {
            Gb.tr("i(" + n2 + ")" + " m_fArray(" + m_fVertex[n2] + ")");
        }
        for (n2 = 0; n2 < PLANE_TEXCODE_NUM * n; ++n2) {
            Gb.tr("i(" + n2 + ")" + " m_fTexCood(" + m_fTexCood[n2] + ")");
        }
    }

    public static float[] getVertexArray() {
        return m_fVertex;
    }

    public static float[] getTextureCoordArray() {
        return m_fTexCood;
    }

    public void setTexture(Texture texture) {
    }

    public void setBlendMode(String string) {
    }

    public void setBlendMode(int n) {
    }

    public void setTransparency(int n) {
    }

    public void setPerspectiveCorrectionEnabled(boolean bl) {
    }

    static {
        m_nVBOs = new int[2];
    }
}

