/*
 * Decompiled with CFR 0.152.
 */
import com.mexa.opgl.OpglGraphics;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import ksg.Camera;
import ksg.KSGBase;
import ksg.KSGSystem;
import ksg.Matrix44;
import ksg.Model;
import ksg.ModelInst;
import ksg.Motion;
import ksg.SimpleLight;
import ksg.Texture;

class Pricra {
    private Camera m_Camera;
    private SimpleLight m_Light;
    private final int BLOCK_SIZE_X;
    private final int BLOCK_SIZE_Y;
    private final int ROW_NUM;
    private final int COL_NUM;
    private int[][] pixels_ = new int[64][];
    private int current_ = 0;
    private final int x_ = (Util.SCR_REAL_W - 64) / 2;
    private final int y_ = (Util.SCR_REAL_H - 32) / 2;
    private Transform viewMatrix_;
    private Graphics gc_;
    private Model figure_;
    private ModelInst[][] figureInst_;
    private Motion[] actionTable_;
    private Texture[] texture_;
    private int actionIndex_;
    private int time_;
    private boolean isFinishedProjection_;
    public static final String[] billTexName = new String[]{"WPSWD", "WPSPR"};
    static byte[] buf = new byte[2];

    public Pricra(Graphics graphics) {
        this.BLOCK_SIZE_X = 64;
        this.BLOCK_SIZE_Y = 32;
        this.ROW_NUM = 8;
        this.COL_NUM = 8;
        this.gc_ = graphics;
        float[] fArray = new float[]{1.0f, 1.0f};
        this.m_Camera = new Camera(fArray);
        this.m_Camera.m_vPos.y = 0.0f;
        this.m_Camera.m_vRef.y = 0.0f;
        this.m_Camera.m_vRef.z = 0.0f;
        this.m_Camera.UpdateW2VMatrix();
        this.m_Camera.UpdateV2CMatrix();
        this.m_Light = new SimpleLight();
        this.viewMatrix_ = new Transform();
        this.figure_ = null;
        this.actionTable_ = null;
        this.texture_ = null;
        this.actionIndex_ = 0;
        this.time_ = 0;
        this.isFinishedProjection_ = false;
    }

    public void term() {
    }

    public void setProjection(float f, float f2, float f3) {
        this.m_Camera.m_fNear = f;
        this.m_Camera.m_fFar = f2;
        this.m_Camera.m_fFov = f3;
        this.m_Camera.UpdateV2CMatrix();
        this.isFinishedProjection_ = true;
    }

    public void setAddLight(Light light, Matrix44 matrix44) {
    }

    public void setFog(Fog fog) {
    }

    public void setCamera(float f, float f2, float f3) {
        this.viewMatrix_.SetIdentity();
        this.viewMatrix_.translate(0.0f, f, f2);
        this.viewMatrix_.rotate(0.0f, 1.0f, 0.0f, f3);
    }

    public void setFigure(Model model, ModelInst[][] modelInstArray) {
        this.figure_ = model;
        this.figureInst_ = modelInstArray;
    }

    public void setActionTable(Motion[] motionArray) {
        this.actionTable_ = new Motion[motionArray.length];
        for (int i = 0; i < motionArray.length; ++i) {
            this.actionTable_[i] = motionArray[i];
        }
    }

    public void setTexture(Texture[] textureArray) {
        this.texture_ = new Texture[textureArray.length];
        for (int i = 0; i < textureArray.length; ++i) {
            this.texture_[i] = textureArray[i];
        }
    }

    public void setAction(int n) {
        if (this.actionTable_ != null && this.actionTable_.length <= n) {
            Gb.tr("[warning] actionTable_.getNumActions() <= index");
        }
        this.actionIndex_ = n;
    }

    public void setTime(int n) {
        if (this.actionTable_ != null && this.actionTable_[this.actionIndex_].GetFrameNum() <= n) {
            Gb.tr("[warning] actionTable_.getMaxFrame (actionIndex_) <= time");
        }
        this.time_ = n;
    }

    public void shoot() {
        if (!this.isFinishedProjection_) {
            Gb.tr("[warning] Setting of projection is not over");
            return;
        }
        if (this.current_ >= 64) {
            Gb.tr("[warning] over shooting");
            return;
        }
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glViewport(this.x_, this.y_, 64, 32);
        this.m_Light.Apply(16384);
        this.m_Camera.Apply();
        this.paint();
        opglGraphics.glFlush();
        opglGraphics.release();
        opglGraphics.bind((Object)this.gc_);
        this.pixels_[this.current_] = new int[2048];
        this.pixels_[this.current_] = DtoSLib.getRGBPixels(this.gc_, this.x_, this.y_, 64, 32, this.pixels_[this.current_], 0);
        ++this.current_;
    }

    public void nextLine() {
        if (this.current_ % 8 == 0) {
            return;
        }
        this.current_ += 8 - this.current_ % 8;
    }

    public void createTexture(Texture[][] textureArray, int n) throws IOException {
        InputStream inputStream = DtoSLib.getSDBindingData(billTexName[n]);
        inputStream.read(SDBinding.b4);
        this.current_ = Gb.chgByteInt(SDBinding.b4);
        byte[] byArray = new byte[4096];
        for (int i = 0; i < this.current_; ++i) {
            Gb.readDataInputStream(inputStream, byArray, byArray.length);
            textureArray[i] = Texture.CreateFromJFTX(byArray, (short)64, (short)32, (byte)4, (byte)3);
        }
        inputStream.close();
    }

    public static byte[] int2Byte(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n >>> 24 & 0xFF) / 8;
        int n7 = (n >>> 16 & 0xFF) / 8;
        int n8 = (n >>> 8 & 0xFF) / 8;
        int n9 = (n >>> 0 & 0xFF) / 8;
        Pricra.buf[0] = (byte)(n7 << 3 & 0xF8);
        buf[0] = (byte)(buf[0] | (byte)(n8 >> 2 & 7));
        Pricra.buf[1] = (byte)(n8 << 6 & 0xC0);
        buf[1] = (byte)(buf[1] | (byte)(n9 << 1 & 0x3E));
        if (n2 == n7 && n3 == n8 && n4 == n9 && n5 == n6) {
            Pricra.buf[0] = 0;
            Pricra.buf[1] = 0;
        } else {
            buf[1] = (byte)(buf[1] | 1);
        }
        return buf;
    }

    private void paint() {
        OpglGraphics opglGraphics = KSGBase.GetGL();
        opglGraphics.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        opglGraphics.glClear(0x4000 | 0x100);
        KSGSystem.BeginRender();
        this.figureInst_[this.actionIndex_][this.time_].Render(this.figure_, this.texture_[0], this.viewMatrix_);
        KSGSystem.EndRender();
    }
}

