/*
 * Decompiled with CFR 0.152.
 */
final class PrimitiveArray {
    public int[] vertex = null;
    public int[] normal = null;
    public int[] textureCoord = null;
    public int[] color = null;
    public int size;
    public int type;
    public int param;
    public int vertexSize = 0;
    public int normalSize = 0;
    public int textureCoordSize = 0;
    public int colorSize = 0;

    PrimitiveArray(int n, int n2, int n3) {
        this.type = n;
        this.param = n2;
        this.size = n3;
        if (this.type == 0x4000000) {
            this.vertexSize = 4;
        } else if (this.type == 0x3000000) {
            this.vertexSize = 3;
        } else if (this.type == 0x2000000) {
            this.vertexSize = 2;
        }
        if ((this.param & 0x200) != 0) {
            this.normalSize = 1;
        } else if ((this.param & 0x300) != 0) {
            this.normalSize = this.vertexSize;
        }
        if ((this.param & 0x3000) != 0) {
            this.textureCoordSize = this.vertexSize;
        }
        if ((this.param & 0x400) != 0) {
            this.colorSize = 1;
        } else if ((this.param & 0x800) != 0) {
            this.colorSize = this.vertexSize;
        }
        this.vertexSize *= 3;
        this.normalSize *= 3;
        this.textureCoordSize *= 2;
        this.vertex = new int[this.size * this.vertexSize];
        this.normal = new int[this.size * this.normalSize];
        this.textureCoord = new int[this.size * this.textureCoordSize];
        this.color = new int[this.size * this.colorSize];
    }

    public int[] getColorArray() {
        return this.color;
    }

    public int[] getNormalArray() {
        return this.normal;
    }

    public int getParam() {
        return this.param;
    }

    public int[] getPointSpriteArray() {
        return null;
    }

    public int[] getTextureCoordArray() {
        return this.textureCoord;
    }

    public int getType() {
        return this.type;
    }

    public int[] getVertexArray() {
        return this.vertex;
    }

    public int size() {
        return this.size;
    }
}

