/*
 * Decompiled with CFR 0.152.
 */
import com.jblend.graphics.j3d.AffineTrans;
import com.jblend.graphics.j3d.Vector3D;

final class Camera {
    public AffineTrans vtrans;
    public Vector3D pos = new Vector3D();
    public Vector3D vpos = new Vector3D();
    private Vector3D up = new Vector3D();
    private Vector3D hpos = new Vector3D();
    public Vector3D npos = new Vector3D();
    public Vector3D mpos;
    public Vector3D angle;
    private Vector3D ani_mpos;
    private int mpos_cnt;
    private Vector3D ani_spin;
    private int spin_cnt;
    private int hoseicnt;
    private static AffineTrans xtrans = new AffineTrans();
    private static AffineTrans ytrans = new AffineTrans();
    private static Vector3D v1 = new Vector3D();
    private static Vector3D v2 = new Vector3D();

    Camera() {
    }

    public void init(int n, int n2, int n3, int n4, int n5, int n6) {
        this.vtrans = new AffineTrans();
        this.mpos = new Vector3D(0, 0, 0);
        this.angle = new Vector3D(0, 0, 0);
        this.pos.x = n;
        this.pos.y = n2;
        this.pos.z = n3;
        this.vpos.x = n4;
        this.vpos.y = n5;
        this.vpos.z = n6;
        this.up.x = 0;
        this.up.y = 4096;
        this.up.z = 0;
        this.ani_mpos = new Vector3D(0, 0, 0);
        this.mpos_cnt = 0;
        this.ani_spin = new Vector3D(0, 0, 0);
        this.spin_cnt = 0;
        this.hoseicnt = 0;
    }

    public void setPosition(int n, int n2, int n3) {
        this.mpos.x = n;
        this.mpos.y = n2;
        this.mpos.z = n3;
    }

    public void setAngle(int n, int n2, int n3) {
        this.angle.x = n;
        this.angle.y = n2;
        this.angle.z = n3;
        this.angle.x = (this.angle.x + 4096) % 4096;
        this.angle.y = (this.angle.y + 4096) % 4096;
        this.angle.z = (this.angle.z + 4096) % 4096;
    }

    public void setMove(Vector3D vector3D, int n) {
        this.ani_mpos.x = vector3D.x;
        this.ani_mpos.y = vector3D.y;
        this.ani_mpos.z = vector3D.z;
        this.mpos_cnt = n;
    }

    public void setSpin(Vector3D vector3D, int n) {
        this.ani_spin.x = vector3D.x;
        this.ani_spin.y = vector3D.y;
        this.ani_spin.z = vector3D.z;
        this.spin_cnt = n;
    }

    public int anime() {
        int n = 0;
        if (this.mpos_cnt != 0) {
            this.mpos.x += (this.ani_mpos.x - this.mpos.x) / this.mpos_cnt;
            this.mpos.y += (this.ani_mpos.y - this.mpos.y) / this.mpos_cnt;
            this.mpos.z += (this.ani_mpos.z - this.mpos.z) / this.mpos_cnt;
            --this.mpos_cnt;
            if (this.mpos_cnt != 0) {
                n |= 1;
            }
        }
        if (this.spin_cnt != 0) {
            this.angle.x += (this.ani_spin.x - this.angle.x) / this.spin_cnt;
            this.angle.y += (this.ani_spin.y - this.angle.y) / this.spin_cnt;
            this.angle.z += (this.ani_spin.z - this.angle.z) / this.spin_cnt;
            if (this.angle.x < 0) {
                this.angle.x += 4096;
                this.ani_spin.x += 4096;
            } else if (this.angle.x >= 4096) {
                this.angle.x -= 4096;
                this.ani_spin.x -= 4096;
            }
            if (this.angle.y < 0) {
                this.angle.y += 4096;
                this.ani_spin.y += 4096;
            } else if (this.angle.y >= 4096) {
                this.angle.y -= 4096;
                this.ani_spin.y -= 4096;
            }
            if (this.angle.z < 0) {
                this.angle.z += 4096;
                this.ani_spin.z += 4096;
            } else if (this.angle.z >= 4096) {
                this.angle.z -= 4096;
                this.ani_spin.z -= 4096;
            }
            --this.spin_cnt;
            if (this.spin_cnt != 0) {
                n |= 2;
            } else {
                this.angle.x = (this.angle.x + 4096) % 4096;
                this.angle.y = (this.angle.y + 4096) % 4096;
                this.angle.z = (this.angle.z + 4096) % 4096;
            }
            if (this.angle.x > 1024) {
                this.angle.x = 0;
            }
            if (this.angle.x > 960) {
                this.angle.x = 960;
            }
        }
        return n;
    }

    public int getKeyAngle(int n) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 = 4096 + this.angle.y;
            if ((n & 0x20) != 0) {
                n2 += 512;
            }
            if ((n & 0x100) != 0) {
                n2 -= 512;
            }
        } else if ((n & 0x200) != 0) {
            n2 = 2048 + this.angle.y;
            if ((n & 0x20) != 0) {
                n2 -= 512;
            }
            if ((n & 0x100) != 0) {
                n2 += 512;
            }
        } else if ((n & 0x20) != 0) {
            n2 = 1024 + this.angle.y;
        } else if ((n & 0x100) != 0) {
            n2 = 3072 + this.angle.y;
        }
        return n2 % 4096;
    }

    public void setTrans(boolean bl) {
        try {
            xtrans.rotationX(this.angle.x);
            ytrans.rotationY(this.angle.y);
            this.vtrans.multiply(ytrans, xtrans);
            v1 = this.vtrans.transPoint(this.pos);
            v2 = this.vtrans.transPoint(this.vpos);
            this.vtrans.set((int[][])new int[][]{{4096, 0, 0, this.mpos.x}, {0, 4096, 0, this.mpos.y}, {0, 0, 4096, this.mpos.z}});
            v1 = this.vtrans.transPoint(v1);
            v2 = this.vtrans.transPoint(v2);
            if (bl) {
                // empty if block
            }
            this.npos.x = Camera.v1.x;
            this.npos.y = Camera.v1.y;
            this.npos.z = Camera.v1.z;
            this.vtrans = Camera.lookAt(v1, v2, this.up);
        }
        catch (Exception exception) {
            ++Camera.v1.x;
            this.vtrans.setViewTrans(v1, v2, this.up);
        }
    }

    public void hitCheck(int n, PrimitiveArray primitiveArray) {
        int[] nArray = new int[9];
        Vector3D vector3D = new Vector3D();
        Vector3D vector3D2 = new Vector3D();
        int n2 = 0;
        int n3 = 360 * this.angle.y / 4096 % 90;
        if (n3 == 0) {
            this.angle.y += 15;
        }
        xtrans.rotationX(this.angle.x);
        ytrans.rotationY(this.angle.y);
        this.vtrans.multiply(ytrans, xtrans);
        v1 = this.vtrans.transPoint(this.pos);
        v2 = this.vtrans.transPoint(this.vpos);
        this.vtrans.set((int[][])new int[][]{{4096, 0, 0, this.mpos.x}, {0, 4096, 0, this.mpos.y}, {0, 0, 4096, this.mpos.z}});
        v1 = this.vtrans.transPoint(v1);
        v2 = this.vtrans.transPoint(v2);
        try {
            for (n3 = 0; n3 < n; ++n3) {
                System.arraycopy(primitiveArray.getVertexArray(), 9 * n3, nArray, 0, 9);
                vector3D.x = primitiveArray.getNormalArray()[0 + n3 * 3];
                vector3D.y = primitiveArray.getNormalArray()[1 + n3 * 3];
                vector3D.z = primitiveArray.getNormalArray()[2 + n3 * 3];
                if (Camera.v1.x == vector3D2.x && Camera.v1.y == vector3D2.y && Camera.v1.z == vector3D2.z || Camera.distans(v1, v2) <= Camera.distans(vector3D2, v2)) continue;
                Camera.v1.x = vector3D2.x;
                Camera.v1.z = vector3D2.z;
                Camera.v1.y = vector3D2.y;
                ++n2;
            }
            Camera.v1.y += (Camera.distans(this.pos, this.vpos) - Camera.distans(v1, this.mpos)) / 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 != 0 && n3 != 0 && (this.npos.x != 0 || this.npos.y != 0 || this.npos.z != 0)) {
            this.hoseicnt = 5;
        }
        if (this.hoseicnt > 0) {
            --this.hoseicnt;
            n3 = Camera.distans(this.npos, v1) / 160 + 1;
            this.hpos.x = this.npos.x + (Camera.v1.x - this.npos.x) / n3;
            this.hpos.y = this.npos.y + (Camera.v1.y - this.npos.y) / n3;
            this.hpos.z = this.npos.z + (Camera.v1.z - this.npos.z) / n3;
        } else {
            this.hpos.x = Camera.v1.x;
            this.hpos.y = Camera.v1.y;
            this.hpos.z = Camera.v1.z;
        }
    }

    static int distans(Vector3D vector3D, Vector3D vector3D2) {
        int n = (vector3D2.x - vector3D.x) * (vector3D2.x - vector3D.x);
        int n2 = (vector3D2.y - vector3D.y) * (vector3D2.y - vector3D.y);
        int n3 = (vector3D2.z - vector3D.z) * (vector3D2.z - vector3D.z);
        return Math.sqrt(n + n2 + n3);
    }

    static AffineTrans lookAt(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        AffineTrans affineTrans = new AffineTrans();
        Vector3D vector3D4 = new Vector3D();
        Vector3D vector3D5 = new Vector3D();
        vector3D4.x = vector3D2.x - vector3D.x;
        vector3D4.y = vector3D2.y - vector3D.y;
        vector3D4.z = vector3D2.z - vector3D.z;
        vector3D4.unit();
        Vector3D vector3D6 = Vector3D.outerProduct((Vector3D)vector3D3, (Vector3D)vector3D4);
        vector3D6.unit();
        Vector3D vector3D7 = Vector3D.outerProduct((Vector3D)vector3D4, (Vector3D)vector3D6);
        vector3D7.unit();
        vector3D5.x = -vector3D6.innerProduct(vector3D) / 4096;
        vector3D5.y = -vector3D7.innerProduct(vector3D) / 4096;
        vector3D5.z = -vector3D4.innerProduct(vector3D) / 4096;
        affineTrans.m00 = -vector3D6.x;
        affineTrans.m10 = -vector3D7.x;
        affineTrans.m20 = vector3D4.x;
        affineTrans.m01 = -vector3D6.y;
        affineTrans.m11 = -vector3D7.y;
        affineTrans.m21 = vector3D4.y;
        affineTrans.m02 = -vector3D6.z;
        affineTrans.m12 = -vector3D7.z;
        affineTrans.m22 = vector3D4.z;
        affineTrans.m03 = -vector3D5.x;
        affineTrans.m13 = -vector3D5.y;
        affineTrans.m23 = vector3D5.z;
        return affineTrans;
    }
}

