/*
 * Decompiled with CFR 0.152.
 */
final class ByteDataControl {
    public byte[] bytedata;
    private int linesize;
    private int[] rowsize;
    private int[] rowtype;
    public int[] numdata;
    public int maxline;
    public int maxrow;
    private int head;

    ByteDataControl(byte[] byArray) {
        int n;
        this.bytedata = byArray;
        this.head = 0;
        this.maxrow = byArray[this.head++] & 0xFF;
        this.rowsize = new int[this.maxrow + 1];
        this.rowtype = new int[this.maxrow];
        this.linesize = 0;
        for (n = 1; n < this.rowsize.length; ++n) {
            this.rowtype[n - 1] = byArray[this.head++];
            this.rowsize[n] = this.linesize + (byArray[this.head++] & 0xFF);
            this.linesize = this.rowsize[n];
        }
        this.maxline = (this.bytedata.length - this.head) / this.linesize;
        this.rowsize[0] = 0;
        this.numdata = new int[this.maxrow * this.maxline];
        for (int i = 0; i < this.maxline; ++i) {
            for (int j = 0; j < this.maxrow; ++j) {
                if (this.rowtype[j] == 2) continue;
                int n2 = 0;
                for (n = this.rowsize[j]; n < this.rowsize[j + 1]; ++n) {
                    n2 = (n2 << 8) + (this.bytedata[this.head + i * this.linesize + n] & 0xFF);
                }
                if (this.rowtype[j] == 0 && (n2 & 128 << ((n = this.rowsize[j + 1] - this.rowsize[j] - 1) << 3)) != 0) {
                    while (n >= 0) {
                        n2 -= 255 << (n << 3);
                        --n;
                    }
                }
                this.numdata[i * this.maxrow + j] = --n2;
            }
        }
    }

    int getNumber(int n, int n2) {
        DrawCanvas.nowsyori = 23;
        if (n2 >= this.maxrow) {
            return 0;
        }
        return this.numdata[n * this.maxrow + n2];
    }

    String getString(int n, int n2) {
        if (DrawCanvas.debugflg != 0) {
            DrawCanvas.nowsyori = 24;
        }
        int n3 = 0;
        for (n3 = this.rowsize[n2]; n3 < this.rowsize[n2 + 1] && this.bytedata[this.head + n * this.linesize + n3] != 0; ++n3) {
        }
        return new String(this.bytedata, this.head + n * this.linesize + this.rowsize[n2], n3 - this.rowsize[n2]);
    }
}

